/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.CustomFixedFee;
import com.hedera.hashgraph.sdk.CustomFractionalFee;
import com.hedera.hashgraph.sdk.CustomRoyaltyFee;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class CustomFee {
    @Nullable
    protected AccountId feeCollectorAccountId = null;

    CustomFee() {
    }

    static CustomFee fromProtobuf(com.hedera.hashgraph.sdk.proto.CustomFee customFee) {
        switch (customFee.getFeeCase()) {
            case FIXED_FEE: {
                return CustomFixedFee.fromProtobuf(customFee);
            }
            case FRACTIONAL_FEE: {
                return CustomFractionalFee.fromProtobuf(customFee);
            }
            case ROYALTY_FEE: {
                return CustomRoyaltyFee.fromProtobuf(customFee);
            }
        }
        throw new IllegalStateException("CustomFee#fromProtobuf: unhandled fee case: " + customFee.getFeeCase());
    }

    public static CustomFee fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return CustomFee.fromProtobuf((com.hedera.hashgraph.sdk.proto.CustomFee)((CustomFee.Builder)com.hedera.hashgraph.sdk.proto.CustomFee.parseFrom(bytes).toBuilder()).build());
    }

    public static List<CustomFee> deepCloneList(List<CustomFee> customFees) {
        ArrayList<CustomFee> returnCustomFees = new ArrayList<CustomFee>(customFees.size());
        for (CustomFee fee : customFees) {
            returnCustomFees.add(fee.deepClone());
        }
        return returnCustomFees;
    }

    @Nullable
    public AccountId getFeeCollectorAccountId() {
        return this.feeCollectorAccountId;
    }

    protected void doSetFeeCollectorAccountId(AccountId feeCollectorAccountId) {
        this.feeCollectorAccountId = Objects.requireNonNull(feeCollectorAccountId);
    }

    CustomFee deepClone() {
        if (this instanceof CustomFixedFee) {
            return CustomFixedFee.clonedFrom((CustomFixedFee)this);
        }
        if (this instanceof CustomFractionalFee) {
            return CustomFractionalFee.clonedFrom((CustomFractionalFee)this);
        }
        return CustomRoyaltyFee.clonedFrom((CustomRoyaltyFee)this);
    }

    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.feeCollectorAccountId != null) {
            this.feeCollectorAccountId.validateChecksum(client);
        }
    }

    protected com.hedera.hashgraph.sdk.proto.CustomFee finishToProtobuf(CustomFee.Builder customFeeBuilder) {
        if (this.getFeeCollectorAccountId() != null) {
            customFeeBuilder.setFeeCollectorAccountId(this.getFeeCollectorAccountId().toProtobuf());
        }
        return (com.hedera.hashgraph.sdk.proto.CustomFee)customFeeBuilder.build();
    }

    abstract com.hedera.hashgraph.sdk.proto.CustomFee toProtobuf();

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

