/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractDeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ContractDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractDeleteTransaction> {
    @Nullable
    private ContractId contractId = null;
    @Nullable
    private ContractId transferContractId = null;
    @Nullable
    private AccountId transferAccountId = null;

    public ContractDeleteTransaction() {
    }

    ContractDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    ContractDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public ContractId getContractId() {
        return this.contractId;
    }

    public ContractDeleteTransaction setContractId(ContractId contractId) {
        Objects.requireNonNull(contractId);
        this.requireNotFrozen();
        this.contractId = contractId;
        return this;
    }

    @Nullable
    public AccountId getTransferAccountId() {
        return this.transferAccountId;
    }

    public ContractDeleteTransaction setTransferAccountId(AccountId transferAccountId) {
        Objects.requireNonNull(transferAccountId);
        this.requireNotFrozen();
        this.transferAccountId = transferAccountId;
        return this;
    }

    @Nullable
    public ContractId getTransferContractId() {
        return this.transferContractId;
    }

    public ContractDeleteTransaction setTransferContractId(ContractId transferContractId) {
        Objects.requireNonNull(transferContractId);
        this.requireNotFrozen();
        this.transferContractId = transferContractId;
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.contractId != null) {
            this.contractId.validateChecksum(client);
        }
        if (this.transferContractId != null) {
            this.transferContractId.validateChecksum(client);
        }
        if (this.transferAccountId != null) {
            this.transferAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getDeleteContractMethod();
    }

    void initFromTransactionBody() {
        ContractDeleteTransactionBody body = this.sourceTransactionBody.getContractDeleteInstance();
        if (body.hasContractID()) {
            this.contractId = ContractId.fromProtobuf(body.getContractID());
        }
        if (body.hasTransferContractID()) {
            this.transferContractId = ContractId.fromProtobuf(body.getTransferContractID());
        }
        if (body.hasTransferAccountID()) {
            this.transferAccountId = AccountId.fromProtobuf(body.getTransferAccountID());
        }
    }

    ContractDeleteTransactionBody.Builder build() {
        ContractDeleteTransactionBody.Builder builder = ContractDeleteTransactionBody.newBuilder();
        if (this.contractId != null) {
            builder.setContractID(this.contractId.toProtobuf());
        }
        if (this.transferAccountId != null) {
            builder.setTransferAccountID(this.transferAccountId.toProtobuf());
        }
        if (this.transferContractId != null) {
            builder.setTransferContractID(this.transferContractId.toProtobuf());
        }
        return builder;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractDeleteInstance(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setContractDeleteInstance(this.build());
    }
}

