/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public final class ContractCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractCreateTransaction> {
    @Nullable
    private FileId bytecodeFileId = null;
    @Nullable
    private byte[] bytecode = null;
    @Nullable
    @Deprecated
    private AccountId proxyAccountId = null;
    @Nullable
    private Key adminKey = null;
    private long gas = 0L;
    private Hbar initialBalance = new Hbar(0L);
    private int maxAutomaticTokenAssociations = 0;
    @Nullable
    private Duration autoRenewPeriod = null;
    private byte[] constructorParameters = new byte[0];
    private String contractMemo = "";
    @Nullable
    private AccountId stakedAccountId = null;
    @Nullable
    private Long stakedNodeId = null;
    private boolean declineStakingReward = false;
    @Nullable
    private AccountId autoRenewAccountId = null;

    public ContractCreateTransaction() {
        this.setAutoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD);
        this.defaultMaxTransactionFee = new Hbar(20L);
    }

    ContractCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    ContractCreateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public FileId getBytecodeFileId() {
        return this.bytecodeFileId;
    }

    public ContractCreateTransaction setBytecodeFileId(FileId bytecodeFileId) {
        Objects.requireNonNull(bytecodeFileId);
        this.requireNotFrozen();
        this.bytecode = null;
        this.bytecodeFileId = bytecodeFileId;
        return this;
    }

    @Nullable
    public byte[] getBytecode() {
        return this.bytecode;
    }

    public ContractCreateTransaction setBytecode(byte[] bytecode) {
        Objects.requireNonNull(bytecode);
        this.requireNotFrozen();
        this.bytecodeFileId = null;
        this.bytecode = bytecode;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public ContractCreateTransaction setAdminKey(Key adminKey) {
        Objects.requireNonNull(adminKey);
        this.requireNotFrozen();
        this.adminKey = adminKey;
        return this;
    }

    public long getGas() {
        return this.gas;
    }

    public ContractCreateTransaction setGas(long gas) {
        this.requireNotFrozen();
        this.gas = gas;
        return this;
    }

    public Hbar getInitialBalance() {
        return this.initialBalance;
    }

    public ContractCreateTransaction setInitialBalance(Hbar initialBalance) {
        Objects.requireNonNull(initialBalance);
        this.requireNotFrozen();
        this.initialBalance = initialBalance;
        return this;
    }

    @Deprecated
    @Nullable
    public AccountId getProxyAccountId() {
        return this.proxyAccountId;
    }

    @Deprecated
    public ContractCreateTransaction setProxyAccountId(AccountId proxyAccountId) {
        Objects.requireNonNull(proxyAccountId);
        this.requireNotFrozen();
        this.proxyAccountId = proxyAccountId;
        return this;
    }

    public int getMaxAutomaticTokenAssociations() {
        return this.maxAutomaticTokenAssociations;
    }

    public ContractCreateTransaction setMaxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
        this.requireNotFrozen();
        this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public ContractCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.requireNotFrozen();
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    public ByteString getConstructorParameters() {
        return ByteString.copyFrom(this.constructorParameters);
    }

    public ContractCreateTransaction setConstructorParameters(byte[] constructorParameters) {
        this.requireNotFrozen();
        this.constructorParameters = constructorParameters;
        return this;
    }

    public ContractCreateTransaction setConstructorParameters(ContractFunctionParameters constructorParameters) {
        Objects.requireNonNull(constructorParameters);
        return this.setConstructorParameters(constructorParameters.toBytes(null).toByteArray());
    }

    public String getContractMemo() {
        return this.contractMemo;
    }

    public ContractCreateTransaction setContractMemo(String memo) {
        this.requireNotFrozen();
        Objects.requireNonNull(memo);
        this.contractMemo = memo;
        return this;
    }

    @Nullable
    public AccountId getStakedAccountId() {
        return this.stakedAccountId;
    }

    public ContractCreateTransaction setStakedAccountId(@Nullable AccountId stakedAccountId) {
        this.requireNotFrozen();
        this.stakedAccountId = stakedAccountId;
        this.stakedNodeId = null;
        return this;
    }

    @Nullable
    public Long getStakedNodeId() {
        return this.stakedNodeId;
    }

    public ContractCreateTransaction setStakedNodeId(@Nullable Long stakedNodeId) {
        this.requireNotFrozen();
        this.stakedNodeId = stakedNodeId;
        this.stakedAccountId = null;
        return this;
    }

    public boolean getDeclineStakingReward() {
        return this.declineStakingReward;
    }

    public ContractCreateTransaction setDeclineStakingReward(boolean declineStakingReward) {
        this.requireNotFrozen();
        this.declineStakingReward = declineStakingReward;
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public ContractCreateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        Objects.requireNonNull(autoRenewAccountId);
        this.requireNotFrozen();
        this.autoRenewAccountId = autoRenewAccountId;
        return this;
    }

    ContractCreateTransactionBody.Builder build() {
        ContractCreateTransactionBody.Builder builder = ContractCreateTransactionBody.newBuilder();
        if (this.bytecodeFileId != null) {
            builder.setFileID(this.bytecodeFileId.toProtobuf());
        }
        if (this.bytecode != null) {
            builder.setInitcode(ByteString.copyFrom(this.bytecode));
        }
        if (this.proxyAccountId != null) {
            builder.setProxyAccountID(this.proxyAccountId.toProtobuf());
        }
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        builder.setMaxAutomaticTokenAssociations(this.maxAutomaticTokenAssociations);
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        builder.setGas(this.gas);
        builder.setInitialBalance(this.initialBalance.toTinybars());
        builder.setConstructorParameters(ByteString.copyFrom(this.constructorParameters));
        builder.setMemo(this.contractMemo);
        builder.setDeclineReward(this.declineStakingReward);
        if (this.stakedAccountId != null) {
            builder.setStakedAccountId(this.stakedAccountId.toProtobuf());
        } else if (this.stakedNodeId != null) {
            builder.setStakedNodeId(this.stakedNodeId);
        }
        if (this.autoRenewAccountId != null) {
            builder.setAutoRenewAccountId(this.autoRenewAccountId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.bytecodeFileId != null) {
            this.bytecodeFileId.validateChecksum(client);
        }
        if (this.proxyAccountId != null) {
            this.proxyAccountId.validateChecksum(client);
        }
        if (this.stakedAccountId != null) {
            this.stakedAccountId.validateChecksum(client);
        }
        if (this.autoRenewAccountId != null) {
            this.autoRenewAccountId.validateChecksum(client);
        }
    }

    void initFromTransactionBody() {
        ContractCreateTransactionBody body = this.sourceTransactionBody.getContractCreateInstance();
        if (body.hasFileID()) {
            this.bytecodeFileId = FileId.fromProtobuf(body.getFileID());
        }
        if (body.hasInitcode()) {
            this.bytecode = body.getInitcode().toByteArray();
        }
        if (body.hasProxyAccountID()) {
            this.proxyAccountId = AccountId.fromProtobuf(body.getProxyAccountID());
        }
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        this.maxAutomaticTokenAssociations = body.getMaxAutomaticTokenAssociations();
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        this.gas = body.getGas();
        this.initialBalance = Hbar.fromTinybars(body.getInitialBalance());
        this.constructorParameters = body.getConstructorParameters().toByteArray();
        this.contractMemo = body.getMemo();
        this.declineStakingReward = body.getDeclineReward();
        if (body.hasStakedAccountId()) {
            this.stakedAccountId = AccountId.fromProtobuf(body.getStakedAccountId());
        }
        if (body.hasStakedNodeId()) {
            this.stakedNodeId = body.getStakedNodeId();
        }
        if (body.hasAutoRenewAccountId()) {
            this.autoRenewAccountId = AccountId.fromProtobuf(body.getAutoRenewAccountId());
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getCreateContractMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractCreateInstance(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setContractCreateInstance(this.build());
    }
}

