/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.EvmAddress;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.proto.AccountID;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class AccountId
implements Comparable<AccountId> {
    private static final Pattern ALIAS_ID_REGEX = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.((?:[0-9a-fA-F][0-9a-fA-F])+)$");
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    @Nullable
    public final PublicKey aliasKey;
    @Nullable
    public final EvmAddress aliasEvmAddress;
    @Nullable
    private final String checksum;

    public AccountId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public AccountId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this(shard, realm, num, null);
    }

    AccountId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
        this.aliasKey = null;
        this.aliasEvmAddress = null;
    }

    AccountId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum, @Nullable PublicKey aliasKey, @Nullable EvmAddress aliasEvmAddress) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
        this.aliasKey = aliasKey;
        this.aliasEvmAddress = aliasEvmAddress;
    }

    public static AccountId fromString(String id) {
        try {
            return EntityIdHelper.fromString(id, AccountId::new);
        }
        catch (IllegalArgumentException error) {
            Matcher match = ALIAS_ID_REGEX.matcher(id);
            if (!match.find()) {
                throw new IllegalArgumentException("Invalid Account ID \"" + id + "\": format should look like 0.0.123 or 0.0.123-vfmkw or 0.0.1337BEEF (where 1337BEEF is a hex-encoded, DER-format public key)");
            }
            byte[] aliasBytes = Hex.decode(match.group(3));
            boolean isEvmAddress = aliasBytes.length == 20;
            return new AccountId(Long.parseLong(match.group(1)), Long.parseLong(match.group(2)), 0L, null, isEvmAddress ? null : PublicKey.fromBytesDER(aliasBytes), isEvmAddress ? EvmAddress.fromBytes(aliasBytes) : null);
        }
    }

    public static AccountId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, AccountId::new);
    }

    static AccountId fromProtobuf(AccountID accountId) {
        Objects.requireNonNull(accountId);
        boolean aliasIsEvmAddress = accountId.getAlias().size() == 20;
        return new AccountId(accountId.getShardNum(), accountId.getRealmNum(), accountId.getAccountNum(), null, aliasIsEvmAddress ? null : PublicKey.fromAliasBytes(accountId.getAlias()), aliasIsEvmAddress ? EvmAddress.fromAliasBytes(accountId.getAlias()) : null);
    }

    public static AccountId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return AccountId.fromProtobuf((AccountID)((AccountID.Builder)AccountID.parseFrom(bytes).toBuilder()).build());
    }

    public String toSolidityAddress() {
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    AccountID toProtobuf() {
        AccountID.Builder accountIdBuilder = AccountID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm);
        if (this.aliasKey != null) {
            accountIdBuilder.setAlias(this.aliasKey.toProtobufKey().toByteString());
        } else if (this.aliasEvmAddress != null) {
            accountIdBuilder.setAlias(this.aliasEvmAddress.toProtobufKey().toByteString());
        } else {
            accountIdBuilder.setAccountNum(this.num);
        }
        return (AccountID)accountIdBuilder.build();
    }

    @Deprecated
    public void validate(Client client) throws BadEntityIdException {
        this.validateChecksum(client);
    }

    public void validateChecksum(Client client) throws BadEntityIdException {
        if (this.aliasKey == null) {
            EntityIdHelper.validate(this.shard, this.realm, this.num, client, this.checksum);
        }
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        if (this.aliasKey != null) {
            return this.shard + "." + this.realm + "." + this.aliasKey.toStringDER();
        }
        if (this.aliasEvmAddress != null) {
            return this.shard + "." + this.realm + "." + this.aliasEvmAddress.toString();
        }
        return EntityIdHelper.toString(this.shard, this.realm, this.num);
    }

    public String toStringWithChecksum(Client client) {
        if (this.aliasKey != null) {
            throw new IllegalStateException("toStringWithChecksum cannot be applied to AccountId with aliasKey");
        }
        return EntityIdHelper.toStringWithChecksum(this.shard, this.realm, this.num, client, this.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num, this.aliasKey != null ? this.aliasKey.toBytes() : null);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountId)) {
            return false;
        }
        AccountId otherId = (AccountId)o;
        if (this.aliasKey == null != (otherId.aliasKey == null)) {
            return false;
        }
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num && (this.aliasKey == null || this.aliasKey.equals(otherId.aliasKey));
    }

    @Override
    public int compareTo(AccountId o) {
        Objects.requireNonNull(o);
        int shardComparison = Long.compare(this.shard, o.shard);
        if (shardComparison != 0) {
            return shardComparison;
        }
        int realmComparison = Long.compare(this.realm, o.realm);
        if (realmComparison != 0) {
            return realmComparison;
        }
        int numComparison = Long.compare(this.num, o.num);
        if (numComparison != 0) {
            return numComparison;
        }
        if (this.aliasKey == null != (o.aliasKey == null)) {
            return this.aliasKey != null ? 1 : -1;
        }
        if (this.aliasEvmAddress == null != (o.aliasEvmAddress == null)) {
            return this.aliasEvmAddress != null ? 1 : -1;
        }
        if (this.aliasKey == null) {
            return 0;
        }
        return this.aliasKey.toStringDER().compareTo(o.aliasKey.toStringDER());
    }
}

