/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.CryptoGetAccountBalanceResponse;
import com.hedera.hashgraph.sdk.proto.TokenBalance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnegative;

public class AccountBalance {
    @Nonnegative
    public final Hbar hbars;
    @Deprecated
    @Nonnegative
    public final Map<TokenId, Long> token = new HashMap<TokenId, Long>();
    @Deprecated
    public final Map<TokenId, Long> tokens;
    @Deprecated
    @Nonnegative
    public final Map<TokenId, Integer> tokenDecimals;

    AccountBalance(Hbar hbars, Map<TokenId, Long> token, Map<TokenId, Integer> decimal) {
        this.hbars = hbars;
        this.tokens = token;
        this.tokenDecimals = decimal;
    }

    static AccountBalance fromProtobuf(CryptoGetAccountBalanceResponse protobuf) {
        List<TokenBalance> balanceList = protobuf.getTokenBalancesList();
        HashMap<TokenId, Long> map = new HashMap<TokenId, Long>();
        HashMap<TokenId, Integer> decimalMap = new HashMap<TokenId, Integer>();
        for (int i = 0; i < protobuf.getTokenBalancesCount(); ++i) {
            map.put(TokenId.fromProtobuf(balanceList.get(i).getTokenId()), balanceList.get(i).getBalance());
            decimalMap.put(TokenId.fromProtobuf(balanceList.get(i).getTokenId()), balanceList.get(i).getDecimals());
        }
        return new AccountBalance(Hbar.fromTinybars(protobuf.getBalance()), map, decimalMap);
    }

    public static AccountBalance fromBytes(byte[] data) throws InvalidProtocolBufferException {
        return AccountBalance.fromProtobuf(CryptoGetAccountBalanceResponse.parseFrom(data));
    }

    CryptoGetAccountBalanceResponse toProtobuf() {
        CryptoGetAccountBalanceResponse.Builder protobuf = CryptoGetAccountBalanceResponse.newBuilder().setBalance(this.hbars.toTinybars());
        for (Map.Entry<TokenId, Long> entry : this.tokens.entrySet()) {
            protobuf.addTokenBalances(TokenBalance.newBuilder().setTokenId(entry.getKey().toProtobuf()).setBalance(entry.getValue()).setDecimals(Objects.requireNonNull(this.tokenDecimals.get(entry.getKey()))));
        }
        return (CryptoGetAccountBalanceResponse)protobuf.build();
    }

    public ByteString toBytes() {
        return this.toProtobuf().toByteString();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("hbars", this.hbars).add("tokens", this.tokens).toString();
    }
}

