/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HbarAllowance;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.TokenAllowance;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenNftAllowance;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoDeleteAllowanceTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.NftRemoveAllowance;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class AccountAllowanceDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountAllowanceDeleteTransaction> {
    private final List<HbarAllowance> hbarAllowances = new ArrayList<HbarAllowance>();
    private final List<TokenAllowance> tokenAllowances = new ArrayList<TokenAllowance>();
    private final List<TokenNftAllowance> nftAllowances = new ArrayList<TokenNftAllowance>();
    private final Map<AccountId, Map<TokenId, Integer>> nftMap = new HashMap<AccountId, Map<TokenId, Integer>>();

    public AccountAllowanceDeleteTransaction() {
    }

    AccountAllowanceDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    AccountAllowanceDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    private void initFromTransactionBody() {
        CryptoDeleteAllowanceTransactionBody body = this.sourceTransactionBody.getCryptoDeleteAllowance();
        for (NftRemoveAllowance allowanceProto : body.getNftAllowancesList()) {
            this.getNftSerials(AccountId.fromProtobuf(allowanceProto.getOwner()), TokenId.fromProtobuf(allowanceProto.getTokenId())).addAll(allowanceProto.getSerialNumbersList());
        }
    }

    @Deprecated
    public AccountAllowanceDeleteTransaction deleteAllHbarAllowances(AccountId ownerAccountId) {
        this.requireNotFrozen();
        this.hbarAllowances.add(new HbarAllowance(Objects.requireNonNull(ownerAccountId), null, null));
        return this;
    }

    @Deprecated
    public List<HbarAllowance> getHbarAllowanceDeletions() {
        return new ArrayList<HbarAllowance>(this.hbarAllowances);
    }

    @Deprecated
    public AccountAllowanceDeleteTransaction deleteAllTokenAllowances(TokenId tokenId, AccountId ownerAccountId) {
        this.requireNotFrozen();
        this.tokenAllowances.add(new TokenAllowance(Objects.requireNonNull(tokenId), Objects.requireNonNull(ownerAccountId), null, 0L));
        return this;
    }

    @Deprecated
    public List<TokenAllowance> getTokenAllowanceDeletions() {
        return new ArrayList<TokenAllowance>(this.tokenAllowances);
    }

    public AccountAllowanceDeleteTransaction deleteAllTokenNftAllowances(NftId nftId, AccountId ownerAccountId) {
        this.requireNotFrozen();
        Objects.requireNonNull(nftId);
        this.getNftSerials(Objects.requireNonNull(ownerAccountId), nftId.tokenId).add(nftId.serial);
        return this;
    }

    public List<TokenNftAllowance> getTokenNftAllowanceDeletions() {
        ArrayList<TokenNftAllowance> retval = new ArrayList<TokenNftAllowance>(this.nftAllowances.size());
        for (TokenNftAllowance allowance : this.nftAllowances) {
            retval.add(TokenNftAllowance.copyFrom(allowance));
        }
        return retval;
    }

    private List<Long> getNftSerials(@Nullable AccountId ownerAccountId, TokenId tokenId) {
        AccountId key = ownerAccountId;
        if (this.nftMap.containsKey(key)) {
            Map<TokenId, Integer> innerMap = this.nftMap.get(key);
            if (innerMap.containsKey(tokenId)) {
                return Objects.requireNonNull(this.nftAllowances.get((int)innerMap.get((Object)tokenId).intValue()).serialNumbers);
            }
            return this.newNftSerials(ownerAccountId, tokenId, innerMap);
        }
        HashMap<TokenId, Integer> innerMap = new HashMap<TokenId, Integer>();
        this.nftMap.put(key, innerMap);
        return this.newNftSerials(ownerAccountId, tokenId, innerMap);
    }

    private List<Long> newNftSerials(@Nullable AccountId ownerAccountId, TokenId tokenId, Map<TokenId, Integer> innerMap) {
        innerMap.put(tokenId, this.nftAllowances.size());
        TokenNftAllowance newAllowance = new TokenNftAllowance(tokenId, ownerAccountId, null, new ArrayList<Long>(), null);
        this.nftAllowances.add(newAllowance);
        return newAllowance.serialNumbers;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getDeleteAllowancesMethod();
    }

    CryptoDeleteAllowanceTransactionBody.Builder build() {
        CryptoDeleteAllowanceTransactionBody.Builder builder = CryptoDeleteAllowanceTransactionBody.newBuilder();
        for (TokenNftAllowance allowance : this.nftAllowances) {
            builder.addNftAllowances(allowance.toRemoveProtobuf());
        }
        return builder;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoDeleteAllowance(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoDeleteAllowance(this.build());
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        for (TokenNftAllowance allowance : this.nftAllowances) {
            allowance.validateChecksums(client);
        }
    }
}

