/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi.util;

import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;

public final class Uint {
    private static final int MAX_BIT_LEN = 4096;
    private static final long ZERO = 0L;
    public final int numBits;
    public final BigInteger range;
    public final long rangeLong;
    public final BigInteger halfRange;
    public final long halfRangeLong;
    public final long maskLong;

    public Uint(int numBits) {
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        if (numBits > 4096) {
            throw new IllegalArgumentException("numBits exceeds limit: " + numBits + " > " + 4096);
        }
        this.numBits = numBits;
        this.range = BigInteger.ONE.shiftLeft(numBits);
        long rangeLong = 0L;
        long halfRangeLong = 0L;
        long maskLong = 0L;
        if (this.range.bitLength() < 64) {
            rangeLong = this.range.longValue();
            halfRangeLong = rangeLong >> 1;
            maskLong = rangeLong - 1L;
        }
        this.rangeLong = rangeLong;
        this.halfRange = this.range.shiftRight(1);
        this.halfRangeLong = halfRangeLong;
        this.maskLong = maskLong;
    }

    public long toSignedLong(long unsigned) {
        if (this.rangeLong != 0L) {
            if (unsigned < 0L) {
                throw new IllegalArgumentException("unsigned value is negative: " + unsigned);
            }
            int bitLen = Integers.bitLen(unsigned);
            if (bitLen <= this.numBits) {
                return unsigned >= this.halfRangeLong ? unsigned - this.rangeLong : unsigned;
            }
            throw Uint.tooManyBitsException(bitLen, this.numBits, false);
        }
        return this.toSigned(BigInteger.valueOf(unsigned)).longValue();
    }

    public BigInteger toSigned(BigInteger unsigned) {
        if (unsigned.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("unsigned value is negative: " + unsigned);
        }
        int bitLen = unsigned.bitLength();
        if (bitLen <= this.numBits) {
            return unsigned.compareTo(this.halfRange) >= 0 ? unsigned.subtract(this.range) : unsigned;
        }
        throw Uint.tooManyBitsException(bitLen, this.numBits, false);
    }

    public long toUnsignedLong(long signed) {
        if (this.maskLong != 0L) {
            int bitLen = Integers.bitLen(signed < 0L ? signed ^ 0xFFFFFFFFFFFFFFFFL : signed);
            if (bitLen < this.numBits) {
                return signed & this.maskLong;
            }
            throw Uint.tooManyBitsException(bitLen, this.numBits, true);
        }
        return this.toUnsigned(signed).longValueExact();
    }

    public BigInteger toUnsigned(long signed) {
        return this.toUnsigned(BigInteger.valueOf(signed));
    }

    public BigInteger toUnsigned(BigInteger signed) {
        int bitLen = signed.bitLength();
        if (bitLen < this.numBits) {
            return signed.compareTo(BigInteger.ZERO) >= 0 ? signed : signed.add(this.range);
        }
        throw Uint.tooManyBitsException(bitLen, this.numBits, true);
    }

    private static IllegalArgumentException tooManyBitsException(int bitLen, int rangeNumBits, boolean signed) {
        return signed ? new IllegalArgumentException("signed has too many bits: " + bitLen + " is not less than " + rangeNumBits) : new IllegalArgumentException("unsigned has too many bits: " + bitLen + " > " + rangeNumBits);
    }
}

