/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.util.Integers;
import java.nio.ByteBuffer;

public final class LongType
extends UnitType<Long> {
    LongType(String canonicalType, int bitLength, boolean unsigned) {
        super(canonicalType, Long.class, bitLength, unsigned);
    }

    @Override
    Class<?> arrayClass() {
        return long[].class;
    }

    @Override
    public int typeCode() {
        return 3;
    }

    @Override
    Long decode(ByteBuffer bb, byte[] unitBuffer) {
        return this.decodeValid(bb, unitBuffer).longValue();
    }

    @Override
    public Long parseArgument(String s2) {
        Long lo = Long.parseLong(s2);
        this.validate(lo);
        return lo;
    }

    static void encodeLong(long value, int byteLen, ByteBuffer dest) {
        if (value >= 0L) {
            Encoding.insert00Padding(byteLen - Integers.len(value), dest);
            Integers.putLong(value, dest);
        } else {
            Encoding.insertFFPadding(byteLen - LongType.lenNegative(value), dest);
            LongType.putLongNegative(value, dest);
        }
    }

    private static int lenNegative(long val) {
        if (val != -1L) {
            if ((val >>= 8) != -1L) {
                if ((val >>= 8) != -1L) {
                    if ((val >>= 8) != -1L) {
                        if ((val >>= 8) != -1L) {
                            if ((val >>= 8) != -1L) {
                                if ((val >>= 8) != -1L) {
                                    if (val >> 8 != -1L) {
                                        return 8;
                                    }
                                    return 7;
                                }
                                return 6;
                            }
                            return 5;
                        }
                        return 4;
                    }
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static void putLongNegative(long val, ByteBuffer o) {
        if (val != -1L) {
            byte h2 = (byte)val;
            if ((val >>= 8) != -1L) {
                byte g2 = (byte)val;
                if ((val >>= 8) != -1L) {
                    byte f = (byte)val;
                    if ((val >>= 8) != -1L) {
                        byte e = (byte)val;
                        if ((val >>= 8) != -1L) {
                            byte d = (byte)val;
                            if ((val >>= 8) != -1L) {
                                byte c = (byte)val;
                                if ((val >>= 8) != -1L) {
                                    byte b = (byte)val;
                                    if ((val >>= 8) != -1L) {
                                        o.put((byte)val).put(b).put(c).put(d).put(e).put(f).put(g2).put(h2);
                                    } else {
                                        o.put(b).put(c).put(d).put(e).put(f).put(g2).put(h2);
                                    }
                                } else {
                                    o.put(c).put(d).put(e).put(f).put(g2).put(h2);
                                }
                            } else {
                                o.put(d).put(e).put(f).put(g2).put(h2);
                            }
                        } else {
                            o.put(e).put(f).put(g2).put(h2);
                        }
                    } else {
                        o.put(f).put(g2).put(h2);
                    }
                } else {
                    o.put(g2).put(h2);
                }
            } else {
                o.put(h2);
            }
        }
    }
}

