/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.ContractError;
import com.esaulpaugh.headlong.abi.Event;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.abi.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public final class ABIJSON {
    public static final Set<TypeEnum> FUNCTIONS = Collections.unmodifiableSet(EnumSet.of(TypeEnum.FUNCTION, TypeEnum.RECEIVE, TypeEnum.FALLBACK, TypeEnum.CONSTRUCTOR));
    public static final Set<TypeEnum> EVENTS = Collections.unmodifiableSet(EnumSet.of(TypeEnum.EVENT));
    public static final Set<TypeEnum> ERRORS = Collections.unmodifiableSet(EnumSet.of(TypeEnum.ERROR));
    public static final Set<TypeEnum> ALL = Collections.unmodifiableSet(EnumSet.allOf(TypeEnum.class));
    private static final String NAME = "name";
    private static final String TYPE = "type";
    static final String FUNCTION = "function";
    static final String RECEIVE = "receive";
    static final String FALLBACK = "fallback";
    static final String CONSTRUCTOR = "constructor";
    static final String EVENT = "event";
    static final String ERROR = "error";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String TUPLE = "tuple";
    private static final String COMPONENTS = "components";
    private static final String ANONYMOUS = "anonymous";
    private static final String INDEXED = "indexed";
    private static final String STATE_MUTABILITY = "stateMutability";
    static final String PAYABLE = "payable";

    private ABIJSON() {
    }

    static <T extends ABIObject> T parseABIObject(String objectJson) {
        return ABIJSON.parseABIObject(JsonUtils.parseObject(objectJson));
    }

    static <T extends ABIObject> T parseABIObject(JsonObject object) {
        return ABIJSON.parseABIObject(TypeEnum.parse(ABIJSON.getType(object)), object, Function::newDefaultDigest);
    }

    public static List<Function> parseNormalFunctions(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, EnumSet.of(TypeEnum.FUNCTION));
    }

    public static List<Function> parseFunctions(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, FUNCTIONS);
    }

    public static List<Event> parseEvents(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, EVENTS);
    }

    public static List<ContractError> parseErrors(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, ERRORS);
    }

    public static List<ABIObject> parseElements(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, ALL);
    }

    public static <T extends ABIObject> List<T> parseElements(String arrayJson, Set<TypeEnum> types) {
        ArrayList<T> selected = new ArrayList<T>();
        MessageDigest digest = Function.newDefaultDigest();
        for (JsonElement e : JsonUtils.parseArray(arrayJson)) {
            JsonObject object;
            TypeEnum t;
            if (!e.isJsonObject() || !types.contains((Object)(t = TypeEnum.parse(ABIJSON.getType(object = e.getAsJsonObject()))))) continue;
            selected.add(ABIJSON.parseABIObject(t, object, () -> digest));
        }
        return selected;
    }

    private static <T extends ABIObject> T parseABIObject(TypeEnum t, JsonObject object, Supplier<MessageDigest> digest) {
        switch (t.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return (T)ABIJSON.parseFunctionUnchecked(t, object, digest.get());
            }
            case 4: {
                return (T)ABIJSON.parseEventUnchecked(object);
            }
            case 5: {
                return (T)ABIJSON.parseErrorUnchecked(object);
            }
        }
        throw new AssertionError();
    }

    static Function parseFunction(JsonObject function, MessageDigest digest) {
        TypeEnum t = TypeEnum.parse(ABIJSON.getType(function));
        if (FUNCTIONS.contains((Object)t)) {
            return ABIJSON.parseFunctionUnchecked(t, function, digest);
        }
        throw TypeEnum.unexpectedType(ABIJSON.getType(function));
    }

    static Event parseEvent(JsonObject event) {
        if (!EVENT.equals(ABIJSON.getType(event))) {
            throw TypeEnum.unexpectedType(ABIJSON.getType(event));
        }
        return ABIJSON.parseEventUnchecked(event);
    }

    static ContractError parseError(JsonObject error) {
        if (!ERROR.equals(ABIJSON.getType(error))) {
            throw TypeEnum.unexpectedType(ABIJSON.getType(error));
        }
        return ABIJSON.parseErrorUnchecked(error);
    }

    private static Function parseFunctionUnchecked(TypeEnum type, JsonObject function, MessageDigest digest) {
        return new Function(type, ABIJSON.getName(function), ABIJSON.parseTupleType(function, INPUTS), ABIJSON.parseTupleType(function, OUTPUTS), JsonUtils.getString(function, STATE_MUTABILITY), digest);
    }

    private static Event parseEventUnchecked(JsonObject event) {
        JsonArray inputs = JsonUtils.getArray(event, INPUTS);
        if (inputs != null) {
            int inputsLen = inputs.size();
            String[] elementNames = new String[inputsLen];
            ABIType[] types = new ABIType[inputsLen];
            boolean[] indexed = new boolean[inputsLen];
            for (int i = 0; i < inputsLen; ++i) {
                JsonObject inputObj = inputs.get(i).getAsJsonObject();
                elementNames[i] = ABIJSON.getName(inputObj);
                types[i] = ABIJSON.parseType(inputObj);
                indexed[i] = JsonUtils.getBoolean(inputObj, INDEXED);
            }
            return new Event(ABIJSON.getName(event), JsonUtils.getBoolean(event, ANONYMOUS, false), TupleType.wrap(elementNames, types), indexed);
        }
        throw new IllegalArgumentException("array \"inputs\" null or not found");
    }

    private static ContractError parseErrorUnchecked(JsonObject error) {
        return new ContractError(ABIJSON.getName(error), ABIJSON.parseTupleType(error, INPUTS));
    }

    private static TupleType parseTupleType(JsonObject object, String arrayKey) {
        int size;
        JsonArray array = JsonUtils.getArray(object, arrayKey);
        if (array == null || (size = array.size()) <= 0) {
            return TupleType.EMPTY;
        }
        String[] elementNames = new String[size];
        ABIType[] elements = new ABIType[size];
        for (int i = 0; i < size; ++i) {
            JsonObject obj = array.get(i).getAsJsonObject();
            elementNames[i] = ABIJSON.getName(obj);
            elements[i] = ABIJSON.parseType(obj);
        }
        return TupleType.wrap(elementNames, elements);
    }

    private static ABIType<?> parseType(JsonObject object) {
        String type = ABIJSON.getType(object);
        if (type.startsWith(TUPLE)) {
            if (type.length() == TUPLE.length()) {
                return ABIJSON.parseTupleType(object, COMPONENTS);
            }
            TupleType baseType = ABIJSON.parseTupleType(object, COMPONENTS);
            return TypeFactory.build(baseType.canonicalType + type.substring(TUPLE.length()), null, baseType);
        }
        return TypeFactory.create(type);
    }

    private static String getType(JsonObject obj) {
        return JsonUtils.getString(obj, TYPE);
    }

    private static String getName(JsonObject obj) {
        return JsonUtils.getString(obj, NAME);
    }

    static String toJson(ABIObject o, boolean pretty) {
        try {
            NonSyncWriter stringOut = new NonSyncWriter();
            JsonWriter out = new JsonWriter(stringOut);
            if (pretty) {
                out.setIndent("  ");
            }
            out.beginObject();
            if (o.isFunction()) {
                Function f = o.asFunction();
                TypeEnum t = o.getType();
                ABIJSON.type(out, t.toString());
                if (t != TypeEnum.FALLBACK) {
                    ABIJSON.name(out, o.getName());
                    if (t != TypeEnum.RECEIVE) {
                        ABIJSON.tupleType(out, INPUTS, o.getInputs(), null);
                        if (t != TypeEnum.CONSTRUCTOR) {
                            ABIJSON.tupleType(out, OUTPUTS, f.getOutputs(), null);
                        }
                    }
                }
                ABIJSON.stateMutability(out, f.getStateMutability());
            } else if (o.isEvent()) {
                ABIJSON.type(out, EVENT);
                ABIJSON.name(out, o.getName());
                ABIJSON.tupleType(out, INPUTS, o.getInputs(), o.asEvent().getIndexManifest());
            } else {
                ABIJSON.type(out, ERROR);
                ABIJSON.name(out, o.getName());
                ABIJSON.tupleType(out, INPUTS, o.getInputs(), null);
            }
            out.endObject().close();
            return ((Object)stringOut).toString();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    private static void type(JsonWriter out, String type) throws IOException {
        out.name(TYPE).value(type);
    }

    private static void name(JsonWriter out, String name) throws IOException {
        if (name != null) {
            out.name(NAME).value(name);
        }
    }

    private static void stateMutability(JsonWriter out, String stateMutability) throws IOException {
        if (stateMutability != null) {
            out.name(STATE_MUTABILITY).value(stateMutability);
        }
    }

    private static void tupleType(JsonWriter out, String name, TupleType tupleType, boolean[] indexedManifest) throws IOException {
        out.name(name).beginArray();
        int i = 0;
        for (ABIType<?> e : tupleType.elementTypes) {
            String type;
            out.beginObject();
            if (tupleType.elementNames != null) {
                ABIJSON.name(out, tupleType.elementNames[i]);
            }
            if ((type = e.canonicalType).charAt(0) == '(') {
                ABIJSON.type(out, TUPLE + type.substring(type.lastIndexOf(41) + 1));
                ABIJSON.tupleType(out, COMPONENTS, (TupleType)ArrayType.baseType(e), null);
            } else {
                ABIJSON.type(out, type);
            }
            if (indexedManifest != null) {
                out.name(INDEXED).value(indexedManifest[i]);
            }
            out.endObject();
            ++i;
        }
        out.endArray();
    }

    private static class NonSyncWriter
    extends CharArrayWriter {
        NonSyncWriter() {
            super(256);
        }

        @Override
        public void write(int c) {
            if (this.count >= this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.buf.length << 1);
            }
            this.buf[this.count++] = (char)c;
        }

        @Override
        public void write(String str, int off, int len) {
            int newCount = this.count + len;
            if (newCount > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newCount));
            }
            str.getChars(off, off + len, this.buf, this.count);
            this.count = newCount;
        }

        @Override
        public NonSyncWriter append(CharSequence csq) {
            String str = csq.toString();
            this.write(str, 0, str.length());
            return this;
        }

        @Override
        public String toString() {
            return new String(this.buf, 0, this.count);
        }
    }
}

