import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum PriceClass {
    /**
     * USA, Canada, Europe, & Israel.
     *
     * @stability stable
     */
    PRICE_CLASS_100 = "PriceClass_100",
    /**
     * PRICE_CLASS_100 + South Africa, Kenya, Middle East, Japan, Singapore, South Korea, Taiwan, Hong Kong, & Philippines.
     *
     * @stability stable
     */
    PRICE_CLASS_200 = "PriceClass_200",
    /**
     * All locations.
     *
     * @stability stable
     */
    PRICE_CLASS_ALL = "PriceClass_All"
}
/**
 * @stability stable
 */
export interface BasicSiteConfiguration {
    /**
     * Local path to the website folder you want to deploy on S3.
     *
     * @stability stable
     */
    readonly websiteFolder: string;
    /**
     * The index document of the website.
     *
     * @stability stable
     */
    readonly indexDoc: string;
    /**
     * The error document of the website.
     *
     * @default - No error document.
     * @stability stable
     */
    readonly errorDoc?: string;
    /**
     * Hosted Zone used to create the DNS record for the website.
     *
     * @stability stable
     */
    readonly hostedZone: string;
}
/**
 * @stability stable
 */
export interface CloudfrontSiteConfiguration {
    /**
     * Local path to the website folder you want to deploy on S3.
     *
     * @stability stable
     */
    readonly websiteFolder: string;
    /**
     * The index document of the website.
     *
     * @stability stable
     */
    readonly indexDoc: string;
    /**
     * The error document of the website.
     *
     * @default - No error document.
     * @stability stable
     */
    readonly errorDoc?: string;
    /**
     * Hosted Zone used to create the DNS record for the website.
     *
     * @stability stable
     */
    readonly hostedZone: string;
    /**
     * Used to deploy a Cloudfront site with a single domain.
     *
     * e.g. sample.example.com
     * If you include a value for both domain and subDomain,
     * an error will be thrown.
     *
     * @default - no value
     * @stability stable
     */
    readonly domain?: string;
    /**
     * The sub-domain name you want to deploy.
     *
     * e.g. www.example.com
     * If you include a value for both domain and subDomain,
     * an error will be thrown.
     *
     * @default - no value
     * @stability stable
     */
    readonly subDomain?: string;
    /**
     * The price class determines how many edge locations CloudFront will use for your distribution.
     *
     * @default PriceClass.PRICE_CLASS_100.
     * @see https://aws.amazon.com/cloudfront/pricing/.
     * @stability stable
     */
    readonly priceClass?: PriceClass;
}
/**
 * @stability stable
 */
export declare class CreateBasicSite extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: BasicSiteConfiguration);
}
/**
 * @stability stable
 */
export declare class CreateCloudfrontSite extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CloudfrontSiteConfiguration);
}
