# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/storage/v1/storage.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class StoragePreSignUrlRequestOperation(betterproto.Enum):
    READ = 0
    WRITE = 1


@dataclass(eq=False, repr=False)
class StorageWriteRequest(betterproto.Message):
    """Request to put (create/update) a storage item"""

    # Nitric name of the bucket to store in  this will be automatically resolved
    # to the provider specific bucket identifier.
    bucket_name: str = betterproto.string_field(1)
    # Key to store the item under
    key: str = betterproto.string_field(2)
    # bytes array to store
    body: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class StorageWriteResponse(betterproto.Message):
    """Result of putting a storage item"""

    pass


@dataclass(eq=False, repr=False)
class StorageReadRequest(betterproto.Message):
    """Request to retrieve a storage item"""

    # Nitric name of the bucket to retrieve from  this will be automatically
    # resolved to the provider specific bucket identifier.
    bucket_name: str = betterproto.string_field(1)
    # Key of item to retrieve
    key: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class StorageReadResponse(betterproto.Message):
    """Returned storage item"""

    # The body bytes of the retrieved storage item
    body: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class StorageDeleteRequest(betterproto.Message):
    """Request to delete a storage item"""

    # Name of the bucket to delete from
    bucket_name: str = betterproto.string_field(1)
    # Key of item to delete
    key: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class StorageDeleteResponse(betterproto.Message):
    """Result of deleting a storage item"""

    pass


@dataclass(eq=False, repr=False)
class StoragePreSignUrlRequest(betterproto.Message):
    """
    Request to generate a pre-signed URL for a file to perform a specific
    operation, such as read or write.
    """

    # Nitric name of the bucket to retrieve from  this will be automatically
    # resolved to the provider specific bucket identifier.
    bucket_name: str = betterproto.string_field(1)
    # Key of item to generate the signed URL for. The URL and the token it
    # contains will only be valid for operations on this resource specifically.
    key: str = betterproto.string_field(2)
    operation: "StoragePreSignUrlRequestOperation" = betterproto.enum_field(3)
    # Expiry time in seconds for the token included in the signed URL.  Time
    # starts from when the access token is generated, not when this request is
    # made.  e.g. time.Now().Add(expiry * time.Second) on the server
    expiry: int = betterproto.uint32_field(4)


@dataclass(eq=False, repr=False)
class StoragePreSignUrlResponse(betterproto.Message):
    # The pre-signed url, restricted to the operation, resource and expiry time
    # specified in the request.
    url: str = betterproto.string_field(1)


class StorageServiceStub(betterproto.ServiceStub):
    async def read(
        self, *, bucket_name: str = "", key: str = ""
    ) -> "StorageReadResponse":

        request = StorageReadRequest()
        request.bucket_name = bucket_name
        request.key = key

        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/Read", request, StorageReadResponse
        )

    async def write(
        self, *, bucket_name: str = "", key: str = "", body: bytes = b""
    ) -> "StorageWriteResponse":

        request = StorageWriteRequest()
        request.bucket_name = bucket_name
        request.key = key
        request.body = body

        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/Write", request, StorageWriteResponse
        )

    async def delete(
        self, *, bucket_name: str = "", key: str = ""
    ) -> "StorageDeleteResponse":

        request = StorageDeleteRequest()
        request.bucket_name = bucket_name
        request.key = key

        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/Delete", request, StorageDeleteResponse
        )

    async def pre_sign_url(
        self,
        *,
        bucket_name: str = "",
        key: str = "",
        operation: "StoragePreSignUrlRequestOperation" = None,
        expiry: int = 0,
    ) -> "StoragePreSignUrlResponse":

        request = StoragePreSignUrlRequest()
        request.bucket_name = bucket_name
        request.key = key
        request.operation = operation
        request.expiry = expiry

        return await self._unary_unary(
            "/nitric.storage.v1.StorageService/PreSignUrl",
            request,
            StoragePreSignUrlResponse,
        )


class StorageServiceBase(ServiceBase):
    async def read(self, bucket_name: str, key: str) -> "StorageReadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def write(
        self, bucket_name: str, key: str, body: bytes
    ) -> "StorageWriteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete(self, bucket_name: str, key: str) -> "StorageDeleteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pre_sign_url(
        self,
        bucket_name: str,
        key: str,
        operation: "StoragePreSignUrlRequestOperation",
        expiry: int,
    ) -> "StoragePreSignUrlResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_read(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "bucket_name": request.bucket_name,
            "key": request.key,
        }

        response = await self.read(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_write(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "bucket_name": request.bucket_name,
            "key": request.key,
            "body": request.body,
        }

        response = await self.write(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delete(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "bucket_name": request.bucket_name,
            "key": request.key,
        }

        response = await self.delete(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pre_sign_url(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "bucket_name": request.bucket_name,
            "key": request.key,
            "operation": request.operation,
            "expiry": request.expiry,
        }

        response = await self.pre_sign_url(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.storage.v1.StorageService/Read": grpclib.const.Handler(
                self.__rpc_read,
                grpclib.const.Cardinality.UNARY_UNARY,
                StorageReadRequest,
                StorageReadResponse,
            ),
            "/nitric.storage.v1.StorageService/Write": grpclib.const.Handler(
                self.__rpc_write,
                grpclib.const.Cardinality.UNARY_UNARY,
                StorageWriteRequest,
                StorageWriteResponse,
            ),
            "/nitric.storage.v1.StorageService/Delete": grpclib.const.Handler(
                self.__rpc_delete,
                grpclib.const.Cardinality.UNARY_UNARY,
                StorageDeleteRequest,
                StorageDeleteResponse,
            ),
            "/nitric.storage.v1.StorageService/PreSignUrl": grpclib.const.Handler(
                self.__rpc_pre_sign_url,
                grpclib.const.Cardinality.UNARY_UNARY,
                StoragePreSignUrlRequest,
                StoragePreSignUrlResponse,
            ),
        }
