import json
import yaml
import os
import sys

from PDFWriter import PDFWriter


def merge_dicts(dictionary):
    """ TODO translate to english 
    
    Recebe um dicionario de dicionarios e retorna um dicionario unico com chave valor, 
    onde valor nao e dicionario.
    
    Recebe:
            dictionary - dicionario de dicionarios.

    Retorna:
            merged_dict - dicionario com chave valor, onde valor nao e dicionario"""
    merged_dict = {}

    for key in dictionary:
        if type(dictionary[key]) is dict:
            merged_dict = {**merged_dict, **merge_dicts(dictionary[key])}
        else:
            merged_dict = {**merged_dict, **{key: dictionary[key]}}
    
    return merged_dict


def remove_item_list(list, item):
    """TODO translate to english
    
    Recebe uma lista e um item a ser retirado da lista e retorna a lista sem o item.
    
    Recebe:
            list - lista

    Retorna:
            list - lista sem o item de entrada"""
    list.remove(item)
    return list


def print_json(input, file_path=None, mode='w'):
    """TODO translate to english
    
    Recebe um dicionario de entrada (input var) e o caminho do arquivo JSON a ser gravado e printa
    o conteudo da entrada no arquivo caso exista. Em caso negativo printa em std_out.
    
    Recebe:
            input - dicionario a ser gravado no arquivo file_path caso exista
            file_path - caminho do arquivo a ser realizado o print do conteudo do dicionario de entrada"""

    if file_path is None:
        print(json.dumps(input, indent=4))
    else:
        print(
            json.dumps(input, indent=4), 
            file=open(file_path, mode)
        )

    return


def print_yaml(input, file_path=None):
    """TODO write docstring"""
    if file_path is None:
        print(yaml.dump(input))
    else:
        print(yaml.dump(input), file=open(file_path, "w"))

    return


def remove_empty_lines(filename):
    """TODO translate to english
    
    Recebe o path de um arquivo e remove as linhas vazias
    
    Recebe:
            filename - path de um arquivo"""
    if not os.path.isfile(filename):
        print("{} does not exist ".format(filename))
        return
    with open(filename) as filehandle:
        lines = filehandle.readlines()

    with open(filename, 'w') as filehandle:
        lines = filter(lambda x: x.strip(), lines)
        filehandle.writelines(lines)  

    return

def error_exit(message):
    """TODO write docstring"""
    sys.stderr.write(message)
    sys.exit(1)

def json_to_pdf(json_data):
    """TODO write docstring"""
    # Get the data values from the JSON string json_data.
    try:
        data = json.loads(json_data)
        pdf_filename = data['pdf_filename']
        font_name = data['font_name']
        font_size = data['font_size']
        header = data['header']
        footer = data['footer']
        lines = data['lines']
    except Exception as e:
        error_exit("Invalid JSON data: {}".format(e.message))
    # Generate the PDF using the data values.
    try:
        with PDFWriter(pdf_filename) as pw:
            pw.setFont(font_name, font_size)
            pw.setHeader(header)
            pw.setFooter(footer)
            for line in lines:
                pw.writeLine(line)
    except IOError as ioe:
        error_exit("IOError while generating PDF file: {}".format(ioe.message))
    except Exception as e:
        error_exit("Error while generating PDF file: {}".format(e.message))
    
    return

def convert_txt_to_pdf(file_path):
    """TODO write docstring"""
    ori_filename = file_path.split('/')[-1]
    filename = f"{ori_filename.split('.')[0]}"
    file_header = filename.replace("_", " ").upper()
    pdf_filename = f"{filename}.pdf"
    with open(file_path, 'r') as file:
        lines = file.readlines()
        data = {
            'pdf_filename': pdf_filename,
            'font_name': 'Courier',
            'font_size': 12,
            'header': file_header,
            'footer': 'Generated by xtopdf - http://google.com/search?q=xtopdf',
            'lines': lines
        }
        json_data = json.dumps(data)
        json_to_pdf(json_data)
    print(f"PDF file converted from {ori_filename} to {pdf_filename}")
    
    return pdf_filename