# papermerge-restapi-client
Document management system designed for digital archives

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.1.0b35
- Package version: 1.0.30
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import papermerge_restapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import papermerge_restapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import papermerge_restapi_client
from pprint import pprint
from papermerge_restapi_client.apis import auth_api
from papermerge_restapi_client.model.auth_token_request import AuthTokenRequest
from papermerge_restapi_client.model.auth_token_response import AuthTokenResponse
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = papermerge_restapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Token Authentication
configuration.api_key['Token Authentication'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Token Authentication'] = 'Bearer'

# Enter a context with an instance of the API client
with papermerge_restapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = auth_api.AuthApi(api_client)
    auth_token_request = AuthTokenRequest(
        username="username_example",
        password="password_example",
    ) # AuthTokenRequest | 

    try:
        api_response = api_instance.auth_login_create(auth_token_request)
        pprint(api_response)
    except papermerge_restapi_client.ApiException as e:
        print("Exception when calling AuthApi->auth_login_create: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**auth_login_create**](docs/apis/tags/AuthApi.md#auth_login_create) | **post** /api/auth/login/ | 
*AuthApi* | [**auth_logout_create**](docs/apis/tags/AuthApi.md#auth_logout_create) | **post** /api/auth/logout/ | 
*AuthApi* | [**auth_logoutall_create**](docs/apis/tags/AuthApi.md#auth_logoutall_create) | **post** /api/auth/logoutall/ | 
*DocumentVersionsApi* | [**document_versions_download_retrieve**](docs/apis/tags/DocumentVersionsApi.md#document_versions_download_retrieve) | **get** /api/document-versions/{id}/download/ | 
*DocumentVersionsApi* | [**document_versions_retrieve**](docs/apis/tags/DocumentVersionsApi.md#document_versions_retrieve) | **get** /api/document-versions/{id}/ | 
*DocumentsApi* | [**document_ocr_text**](docs/apis/tags/DocumentsApi.md#document_ocr_text) | **get** /api/documents/{id}/ocr-text | 
*DocumentsApi* | [**documents_destroy**](docs/apis/tags/DocumentsApi.md#documents_destroy) | **delete** /api/documents/{id}/ | 
*DocumentsApi* | [**documents_list**](docs/apis/tags/DocumentsApi.md#documents_list) | **get** /api/documents/ | 
*DocumentsApi* | [**documents_merge**](docs/apis/tags/DocumentsApi.md#documents_merge) | **post** /api/documents/merge/ | 
*DocumentsApi* | [**documents_partial_update**](docs/apis/tags/DocumentsApi.md#documents_partial_update) | **patch** /api/documents/{id}/ | 
*DocumentsApi* | [**documents_retrieve**](docs/apis/tags/DocumentsApi.md#documents_retrieve) | **get** /api/documents/{id}/ | 
*DocumentsApi* | [**upload_file**](docs/apis/tags/DocumentsApi.md#upload_file) | **put** /api/documents/{document_id}/upload/{file_name} | 
*FoldersApi* | [**folders_create**](docs/apis/tags/FoldersApi.md#folders_create) | **post** /api/folders/ | 
*FoldersApi* | [**folders_destroy**](docs/apis/tags/FoldersApi.md#folders_destroy) | **delete** /api/folders/{id}/ | 
*FoldersApi* | [**folders_list**](docs/apis/tags/FoldersApi.md#folders_list) | **get** /api/folders/ | 
*FoldersApi* | [**folders_partial_update**](docs/apis/tags/FoldersApi.md#folders_partial_update) | **patch** /api/folders/{id}/ | 
*FoldersApi* | [**folders_retrieve**](docs/apis/tags/FoldersApi.md#folders_retrieve) | **get** /api/folders/{id}/ | 
*GroupsApi* | [**groups_create**](docs/apis/tags/GroupsApi.md#groups_create) | **post** /api/groups/ | 
*GroupsApi* | [**groups_destroy**](docs/apis/tags/GroupsApi.md#groups_destroy) | **delete** /api/groups/{id}/ | 
*GroupsApi* | [**groups_list**](docs/apis/tags/GroupsApi.md#groups_list) | **get** /api/groups/ | 
*GroupsApi* | [**groups_partial_update**](docs/apis/tags/GroupsApi.md#groups_partial_update) | **patch** /api/groups/{id}/ | 
*GroupsApi* | [**groups_retrieve**](docs/apis/tags/GroupsApi.md#groups_retrieve) | **get** /api/groups/{id}/ | 
*NodesApi* | [**node_append_tags**](docs/apis/tags/NodesApi.md#node_append_tags) | **patch** /api/nodes/{id}/tags/ | 
*NodesApi* | [**node_assign_tags**](docs/apis/tags/NodesApi.md#node_assign_tags) | **post** /api/nodes/{id}/tags/ | 
*NodesApi* | [**node_dissociate_tags**](docs/apis/tags/NodesApi.md#node_dissociate_tags) | **delete** /api/nodes/{id}/tags/ | 
*NodesApi* | [**node_retrieve**](docs/apis/tags/NodesApi.md#node_retrieve) | **get** /api/nodes/{id}/ | 
*NodesApi* | [**nodes_create**](docs/apis/tags/NodesApi.md#nodes_create) | **post** /api/nodes/ | 
*NodesApi* | [**nodes_destroy**](docs/apis/tags/NodesApi.md#nodes_destroy) | **delete** /api/nodes/{id}/ | 
*NodesApi* | [**nodes_download**](docs/apis/tags/NodesApi.md#nodes_download) | **get** /api/nodes/download/ | 
*NodesApi* | [**nodes_inboxcount_retrieve**](docs/apis/tags/NodesApi.md#nodes_inboxcount_retrieve) | **get** /api/nodes/inboxcount/ | 
*NodesApi* | [**nodes_list**](docs/apis/tags/NodesApi.md#nodes_list) | **get** /api/nodes/ | 
*NodesApi* | [**nodes_move_create**](docs/apis/tags/NodesApi.md#nodes_move_create) | **post** /api/nodes/move/ | 
*NodesApi* | [**nodes_partial_update**](docs/apis/tags/NodesApi.md#nodes_partial_update) | **patch** /api/nodes/{id}/ | 
*OcrApi* | [**ocr_create**](docs/apis/tags/OcrApi.md#ocr_create) | **post** /api/ocr/ | 
*PagesApi* | [**move_to_document**](docs/apis/tags/PagesApi.md#move_to_document) | **post** /api/pages/move-to-document/ | 
*PagesApi* | [**move_to_folder**](docs/apis/tags/PagesApi.md#move_to_folder) | **post** /api/pages/move-to-folder/ | 
*PagesApi* | [**multiple_pages_delete**](docs/apis/tags/PagesApi.md#multiple_pages_delete) | **delete** /api/pages/ | 
*PagesApi* | [**reorder**](docs/apis/tags/PagesApi.md#reorder) | **post** /api/pages/reorder/ | 
*PagesApi* | [**retrieve**](docs/apis/tags/PagesApi.md#retrieve) | **get** /api/pages/{id}/ | 
*PagesApi* | [**rotate**](docs/apis/tags/PagesApi.md#rotate) | **post** /api/pages/rotate/ | 
*PagesApi* | [**single_page_delete**](docs/apis/tags/PagesApi.md#single_page_delete) | **delete** /api/pages/{id}/ | 
*PermissionsApi* | [**permissions_list**](docs/apis/tags/PermissionsApi.md#permissions_list) | **get** /api/permissions/ | 
*PreferencesApi* | [**preferences_bulk_create**](docs/apis/tags/PreferencesApi.md#preferences_bulk_create) | **post** /api/preferences/bulk/ | 
*PreferencesApi* | [**preferences_list**](docs/apis/tags/PreferencesApi.md#preferences_list) | **get** /api/preferences/ | 
*PreferencesApi* | [**preferences_partial_update**](docs/apis/tags/PreferencesApi.md#preferences_partial_update) | **patch** /api/preferences/{id}/ | 
*PreferencesApi* | [**preferences_retrieve**](docs/apis/tags/PreferencesApi.md#preferences_retrieve) | **get** /api/preferences/{id}/ | 
*PreferencesApi* | [**preferences_update**](docs/apis/tags/PreferencesApi.md#preferences_update) | **put** /api/preferences/{id}/ | 
*SchemaApi* | [**schema_retrieve**](docs/apis/tags/SchemaApi.md#schema_retrieve) | **get** /api/schema/ | 
*SearchApi* | [**search**](docs/apis/tags/SearchApi.md#search) | **get** /api/search/ | 
*TagsApi* | [**tags_create**](docs/apis/tags/TagsApi.md#tags_create) | **post** /api/tags/ | 
*TagsApi* | [**tags_destroy**](docs/apis/tags/TagsApi.md#tags_destroy) | **delete** /api/tags/{id}/ | 
*TagsApi* | [**tags_list**](docs/apis/tags/TagsApi.md#tags_list) | **get** /api/tags/ | 
*TagsApi* | [**tags_partial_update**](docs/apis/tags/TagsApi.md#tags_partial_update) | **patch** /api/tags/{id}/ | 
*TagsApi* | [**tags_retrieve**](docs/apis/tags/TagsApi.md#tags_retrieve) | **get** /api/tags/{id}/ | 
*TokensApi* | [**tokens_create**](docs/apis/tags/TokensApi.md#tokens_create) | **post** /api/tokens/ | 
*TokensApi* | [**tokens_destroy**](docs/apis/tags/TokensApi.md#tokens_destroy) | **delete** /api/tokens/{digest}/ | 
*TokensApi* | [**tokens_list**](docs/apis/tags/TokensApi.md#tokens_list) | **get** /api/tokens/ | 
*TokensApi* | [**tokens_retrieve**](docs/apis/tags/TokensApi.md#tokens_retrieve) | **get** /api/tokens/{digest}/ | 
*UsersApi* | [**users_change_password_create**](docs/apis/tags/UsersApi.md#users_change_password_create) | **post** /api/users/{id}/change-password/ | 
*UsersApi* | [**users_create**](docs/apis/tags/UsersApi.md#users_create) | **post** /api/users/ | 
*UsersApi* | [**users_destroy**](docs/apis/tags/UsersApi.md#users_destroy) | **delete** /api/users/{id}/ | 
*UsersApi* | [**users_list**](docs/apis/tags/UsersApi.md#users_list) | **get** /api/users/ | 
*UsersApi* | [**users_me_retrieve**](docs/apis/tags/UsersApi.md#users_me_retrieve) | **get** /api/users/me/ | 
*UsersApi* | [**users_partial_update**](docs/apis/tags/UsersApi.md#users_partial_update) | **patch** /api/users/{id}/ | 
*UsersApi* | [**users_retrieve**](docs/apis/tags/UsersApi.md#users_retrieve) | **get** /api/users/{id}/ | 
*VersionApi* | [**version_retrieve**](docs/apis/tags/VersionApi.md#version_retrieve) | **get** /api/version/ | 

## Documentation For Models

 - [AuthTokenRequest](docs/models/AuthTokenRequest.md)
 - [AuthTokenResponse](docs/models/AuthTokenResponse.md)
 - [CustomUserPreference](docs/models/CustomUserPreference.md)
 - [DataDocumentDetails](docs/models/DataDocumentDetails.md)
 - [DataGroup](docs/models/DataGroup.md)
 - [DataNode](docs/models/DataNode.md)
 - [DataUser](docs/models/DataUser.md)
 - [Datum](docs/models/Datum.md)
 - [DocumentDetails](docs/models/DocumentDetails.md)
 - [DocumentDetailsTypeEnum](docs/models/DocumentDetailsTypeEnum.md)
 - [DocumentVersion](docs/models/DocumentVersion.md)
 - [DocumentVersionOcrText](docs/models/DocumentVersionOcrText.md)
 - [DocumentsMerge](docs/models/DocumentsMerge.md)
 - [Error](docs/models/Error.md)
 - [Errors](docs/models/Errors.md)
 - [Failure](docs/models/Failure.md)
 - [Folder](docs/models/Folder.md)
 - [FolderTypeEnum](docs/models/FolderTypeEnum.md)
 - [Group](docs/models/Group.md)
 - [GroupTypeEnum](docs/models/GroupTypeEnum.md)
 - [Id](docs/models/Id.md)
 - [InboxCount](docs/models/InboxCount.md)
 - [Jsonapi](docs/models/Jsonapi.md)
 - [Link](docs/models/Link.md)
 - [Linkage](docs/models/Linkage.md)
 - [Links](docs/models/Links.md)
 - [Meta](docs/models/Meta.md)
 - [Node](docs/models/Node.md)
 - [NodeID](docs/models/NodeID.md)
 - [NodeMove](docs/models/NodeMove.md)
 - [NodeTags](docs/models/NodeTags.md)
 - [NodeTypeEnum](docs/models/NodeTypeEnum.md)
 - [Ocr](docs/models/Ocr.md)
 - [Onlymeta](docs/models/Onlymeta.md)
 - [Page](docs/models/Page.md)
 - [PageReorder](docs/models/PageReorder.md)
 - [PageRotate](docs/models/PageRotate.md)
 - [PageTypeEnum](docs/models/PageTypeEnum.md)
 - [Pageref](docs/models/Pageref.md)
 - [PagesMoveToDocument](docs/models/PagesMoveToDocument.md)
 - [PagesMoveToFolder](docs/models/PagesMoveToFolder.md)
 - [PagesReorder](docs/models/PagesReorder.md)
 - [PagesRotate](docs/models/PagesRotate.md)
 - [PaginatedCustomUserPreferenceList](docs/models/PaginatedCustomUserPreferenceList.md)
 - [PaginatedDocumentDetailsList](docs/models/PaginatedDocumentDetailsList.md)
 - [PaginatedFolderList](docs/models/PaginatedFolderList.md)
 - [PaginatedGroupList](docs/models/PaginatedGroupList.md)
 - [PaginatedNodeList](docs/models/PaginatedNodeList.md)
 - [PaginatedTagList](docs/models/PaginatedTagList.md)
 - [PaginatedTokenList](docs/models/PaginatedTokenList.md)
 - [PaginatedUserList](docs/models/PaginatedUserList.md)
 - [Pagination](docs/models/Pagination.md)
 - [Password](docs/models/Password.md)
 - [PatchedCustomUserPreference](docs/models/PatchedCustomUserPreference.md)
 - [PatchedDocumentDetails](docs/models/PatchedDocumentDetails.md)
 - [PatchedFolder](docs/models/PatchedFolder.md)
 - [PatchedGroup](docs/models/PatchedGroup.md)
 - [PatchedNode](docs/models/PatchedNode.md)
 - [PatchedNodeTags](docs/models/PatchedNodeTags.md)
 - [PatchedTag](docs/models/PatchedTag.md)
 - [PatchedUser](docs/models/PatchedUser.md)
 - [Permission](docs/models/Permission.md)
 - [RelationshipLinks](docs/models/RelationshipLinks.md)
 - [RelationshipToMany](docs/models/RelationshipToMany.md)
 - [RelationshipToOne](docs/models/RelationshipToOne.md)
 - [Reltomany](docs/models/Reltomany.md)
 - [Reltoone](docs/models/Reltoone.md)
 - [Resource](docs/models/Resource.md)
 - [ResourceIdentifierObject](docs/models/ResourceIdentifierObject.md)
 - [Tag](docs/models/Tag.md)
 - [TagTypeEnum](docs/models/TagTypeEnum.md)
 - [Token](docs/models/Token.md)
 - [TokenTypeEnum](docs/models/TokenTypeEnum.md)
 - [Type](docs/models/Type.md)
 - [User](docs/models/User.md)
 - [UserTypeEnum](docs/models/UserTypeEnum.md)
 - [Version](docs/models/Version.md)

## Documentation For Authorization

 Authentication schemes defined for the API:
## Token Authentication

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author


















## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in papermerge_restapi_client.apis and papermerge_restapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from papermerge_restapi_client.apis.default_api import DefaultApi`
- `from papermerge_restapi_client.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import papermerge_restapi_client
from papermerge_restapi_client.apis import *
from papermerge_restapi_client.models import *
```
