"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UntrustedCodeBoundaryPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Permissions Boundary for a CodeBuild Project running untrusted code
 *
 * This class is a Policy, intended to be used as a Permissions Boundary
 * for a CodeBuild project. It allows most of the actions necessary to run
 * the CodeBuild project, but disallows reading from Parameter Store
 * and Secrets Manager.
 *
 * Use this when your CodeBuild project is running untrusted code (for
 * example, if you are using one to automatically build Pull Requests
 * that anyone can submit), and you want to prevent your future self
 * from accidentally exposing Secrets to this build.
 *
 * (The reason you might want to do this is because otherwise anyone
 * who can submit a Pull Request to your project can write a script
 * to email those secrets to themselves).
 *
 * @example
 *
 * declare const project: codebuild.Project;
 * iam.PermissionsBoundary.of(project).apply(new codebuild.UntrustedCodeBoundaryPolicy(this, 'Boundary'));
 */
class UntrustedCodeBoundaryPolicy extends iam.ManagedPolicy {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id, {
            managedPolicyName: props.managedPolicyName,
            description: 'Permissions Boundary Policy for CodeBuild Projects running untrusted code',
            statements: [
                new iam.PolicyStatement({
                    actions: [
                        // For logging
                        'logs:CreateLogGroup',
                        'logs:CreateLogStream',
                        'logs:PutLogEvents',
                        // For test reports
                        'codebuild:CreateReportGroup',
                        'codebuild:CreateReport',
                        'codebuild:UpdateReport',
                        'codebuild:BatchPutTestCases',
                        'codebuild:BatchPutCodeCoverages',
                        // For batch builds
                        'codebuild:StartBuild',
                        'codebuild:StopBuild',
                        'codebuild:RetryBuild',
                        // For pulling ECR images
                        'ecr:GetDownloadUrlForLayer',
                        'ecr:BatchGetImage',
                        'ecr:BatchCheckLayerAvailability',
                        // For running in a VPC
                        'ec2:CreateNetworkInterfacePermission',
                        'ec2:CreateNetworkInterface',
                        'ec2:DescribeNetworkInterfaces',
                        'ec2:DeleteNetworkInterface',
                        'ec2:DescribeSubnets',
                        'ec2:DescribeSecurityGroups',
                        'ec2:DescribeDhcpOptions',
                        'ec2:DescribeVpcs',
                    ],
                    resources: ['*'],
                }),
                ...(_b = props.additionalStatements) !== null && _b !== void 0 ? _b : [],
            ],
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_UntrustedCodeBoundaryPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.UntrustedCodeBoundaryPolicy = UntrustedCodeBoundaryPolicy;
_a = JSII_RTTI_SYMBOL_1;
UntrustedCodeBoundaryPolicy[_a] = { fqn: "@aws-cdk/aws-codebuild.UntrustedCodeBoundaryPolicy", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,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