"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const codebuild_generated_1 = require("./codebuild.generated");
const report_group_utils_1 = require("./report-group-utils");
class ReportGroupBase extends cdk.Resource {
    grantWrite(identity) {
        const ret = iam.Grant.addToPrincipal({
            grantee: identity,
            actions: [
                'codebuild:CreateReport',
                'codebuild:UpdateReport',
                'codebuild:BatchPutTestCases',
            ],
            resourceArns: [this.reportGroupArn],
        });
        if (this.exportBucket) {
            this.exportBucket.grantWrite(identity);
        }
        return ret;
    }
}
/**
 * The ReportGroup resource class.
 */
class ReportGroup extends ReportGroupBase {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id, {
            physicalName: props.reportGroupName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_ReportGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new codebuild_generated_1.CfnReportGroup(this, 'Resource', {
            type: 'TEST',
            exportConfig: {
                exportConfigType: props.exportBucket ? 'S3' : 'NO_EXPORT',
                s3Destination: props.exportBucket
                    ? {
                        bucket: props.exportBucket.bucketName,
                        encryptionDisabled: props.exportBucket.encryptionKey ? false : undefined,
                        encryptionKey: (_b = props.exportBucket.encryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
                        packaging: props.zipExport ? 'ZIP' : undefined,
                    }
                    : undefined,
            },
            name: props.reportGroupName,
        });
        resource.applyRemovalPolicy(props.removalPolicy, {
            default: cdk.RemovalPolicy.RETAIN,
        });
        this.reportGroupArn = this.getResourceArnAttribute(resource.attrArn, report_group_utils_1.reportGroupArnComponents(this.physicalName));
        this.reportGroupName = this.getResourceNameAttribute(
        // there is no separate name attribute,
        // so use Fn::Select + Fn::Split to make one
        cdk.Fn.select(1, cdk.Fn.split('/', resource.ref)));
        this.exportBucket = props.exportBucket;
    }
    /**
     * Reference an existing ReportGroup,
     * defined outside of the CDK code,
     * by name.
     */
    static fromReportGroupName(scope, id, reportGroupName) {
        class Import extends ReportGroupBase {
            constructor() {
                super(...arguments);
                this.reportGroupName = reportGroupName;
                this.reportGroupArn = report_group_utils_1.renderReportGroupArn(scope, reportGroupName);
                this.exportBucket = undefined;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReportGroup = ReportGroup;
_a = JSII_RTTI_SYMBOL_1;
ReportGroup[_a] = { fqn: "@aws-cdk/aws-codebuild.ReportGroup", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,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