"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineProject = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline_artifacts_1 = require("./codepipeline-artifacts");
const codepipeline_source_1 = require("./codepipeline-source");
const project_1 = require("./project");
/**
 * A convenience class for CodeBuild Projects that are used in CodePipeline.
 */
class PipelineProject extends project_1.Project {
    constructor(scope, id, props) {
        super(scope, id, {
            source: new codepipeline_source_1.CodePipelineSource(),
            artifacts: new codepipeline_artifacts_1.CodePipelineArtifacts(),
            ...props,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_PipelineProjectProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.PipelineProject = PipelineProject;
_a = JSII_RTTI_SYMBOL_1;
PipelineProject[_a] = { fqn: "@aws-cdk/aws-codebuild.PipelineProject", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZWxpbmUtcHJvamVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBpcGVsaW5lLXByb2plY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EscUVBQWlFO0FBQ2pFLCtEQUEyRDtBQUMzRCx1Q0FBd0Q7QUFLeEQ7O0dBRUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsaUJBQU87SUFDMUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLE1BQU0sRUFBRSxJQUFJLHdDQUFrQixFQUFFO1lBQ2hDLFNBQVMsRUFBRSxJQUFJLDhDQUFxQixFQUFFO1lBQ3RDLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQzs7Ozs7Ozs7OztLQUNKOztBQVBILDBDQVFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDb2RlUGlwZWxpbmVBcnRpZmFjdHMgfSBmcm9tICcuL2NvZGVwaXBlbGluZS1hcnRpZmFjdHMnO1xuaW1wb3J0IHsgQ29kZVBpcGVsaW5lU291cmNlIH0gZnJvbSAnLi9jb2RlcGlwZWxpbmUtc291cmNlJztcbmltcG9ydCB7IENvbW1vblByb2plY3RQcm9wcywgUHJvamVjdCB9IGZyb20gJy4vcHJvamVjdCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUGlwZWxpbmVQcm9qZWN0UHJvcHMgZXh0ZW5kcyBDb21tb25Qcm9qZWN0UHJvcHMge1xufVxuXG4vKipcbiAqIEEgY29udmVuaWVuY2UgY2xhc3MgZm9yIENvZGVCdWlsZCBQcm9qZWN0cyB0aGF0IGFyZSB1c2VkIGluIENvZGVQaXBlbGluZS5cbiAqL1xuZXhwb3J0IGNsYXNzIFBpcGVsaW5lUHJvamVjdCBleHRlbmRzIFByb2plY3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IFBpcGVsaW5lUHJvamVjdFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBzb3VyY2U6IG5ldyBDb2RlUGlwZWxpbmVTb3VyY2UoKSxcbiAgICAgIGFydGlmYWN0czogbmV3IENvZGVQaXBlbGluZUFydGlmYWN0cygpLFxuICAgICAgLi4ucHJvcHMsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==