"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Artifacts = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Artifacts definition for a CodeBuild Project.
 */
class Artifacts {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_ArtifactsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.identifier = props.identifier;
    }
    static s3(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_S3ArtifactsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.s3);
            }
            throw error;
        }
        return new S3Artifacts(props);
    }
    bind(_scope, _project) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codebuild_IProject(_project);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            artifactsProperty: {
                artifactIdentifier: this.identifier,
                type: this.type,
            },
        };
    }
}
exports.Artifacts = Artifacts;
_a = JSII_RTTI_SYMBOL_1;
Artifacts[_a] = { fqn: "@aws-cdk/aws-codebuild.Artifacts", version: "1.153.1" };
/**
 * S3 Artifact definition for a CodeBuild Project.
 */
class S3Artifacts extends Artifacts {
    constructor(props) {
        super(props);
        this.props = props;
        this.type = 'S3';
    }
    bind(_scope, project) {
        this.props.bucket.grantReadWrite(project);
        const superConfig = super.bind(_scope, project);
        return {
            artifactsProperty: {
                ...superConfig.artifactsProperty,
                location: this.props.bucket.bucketName,
                path: this.props.path,
                namespaceType: this.props.includeBuildId === false ? 'NONE' : 'BUILD_ID',
                name: this.props.name == null ? undefined : this.props.name,
                packaging: this.props.packageZip === false ? 'NONE' : 'ZIP',
                encryptionDisabled: this.props.encryption === false ? true : undefined,
                overrideArtifactName: this.props.name == null ? true : undefined,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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