# Generated by Django 2.2.13 on 2021-02-18 18:39

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jsonfield.fields
import orchestra.models.core.mixins
import orchestra.utils.datetime_utils
import orchestra.utils.models


class Migration(migrations.Migration):

    dependencies = [
        ('orchestra', '0091_auto_20210121_1952'),
    ]

    operations = [
        migrations.AddField(
            model_name='step',
            name='assignable_hours_function',
            field=jsonfield.fields.JSONField(default={}),
        ),
        migrations.AddField(
            model_name='worker',
            name='max_autostaff_hours_per_day',
            field=models.FloatField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name='staffbotrequest',
            name='request_cause',
            field=models.IntegerField(choices=[(0, 'user'), (1, 'task policy'), (2, 'restaff')]),
        ),
        migrations.AlterField(
            model_name='staffingrequestinquiry',
            name='communication_method',
            field=models.IntegerField(choices=[(0, 'slack'), (1, 'email'), (2, 'already opted in')]),
        ),
        migrations.CreateModel(
            name='WorkerAvailability',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('is_deleted', models.BooleanField(default=False)),
                ('week', models.DateField(default=orchestra.utils.datetime_utils.first_day_of_the_week)),
                ('hours_available_mon', models.FloatField(default=0, verbose_name='Monday')),
                ('hours_available_tues', models.FloatField(default=0, verbose_name='Tuesday')),
                ('hours_available_wed', models.FloatField(default=0, verbose_name='Wednesday')),
                ('hours_available_thurs', models.FloatField(default=0, verbose_name='Thursday')),
                ('hours_available_fri', models.FloatField(default=0, verbose_name='Friday')),
                ('hours_available_sat', models.FloatField(default=0, verbose_name='Saturday')),
                ('hours_available_sun', models.FloatField(default=0, verbose_name='Sunday')),
                ('worker', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='availabilities', to='orchestra.Worker')),
            ],
            bases=(orchestra.models.core.mixins.WorkerAvailabilityMixin, orchestra.utils.models.DeleteMixin, models.Model),
        ),
        migrations.AddConstraint(
            model_name='workeravailability',
            constraint=models.UniqueConstraint(fields=('worker', 'week'), name='uniq_worker_week'),
        ),
    ]
