# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2017-10-25 08:37
from __future__ import unicode_literals

from django.db import migrations


def copy_staffing_priority(apps, schema_editor):
    Worker = apps.get_model('orchestra', 'Worker')
    for worker in Worker.objects.all():
        # Set worker certification staffing priority
        # the same as original worker staffing priority.
        for certification in worker.certifications.all():
            certification.staffing_priority = worker.staffing_priority
            certification.save()


class Migration(migrations.Migration):

    dependencies = [
        ('orchestra', '0071_workercertification_staffing_priority'),
    ]

    operations = [
        migrations.RunPython(copy_staffing_priority)  # manually-reviewed
    ]
