# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-29 06:44
from __future__ import unicode_literals

from enum import Enum

from django.db import migrations

################ CommunicationType Migration Boilerplate Start ################
# NOTE(joshblum): Future migrations that add a CommunicationType should copy
# paste all of this boilerplate code, so you just have to specify the correct
# COMMUNICATION_METHODS you want to be configurable.


class CommunicationMethods(object):
    # Copy pasted from models since migrations does not have access
    SLACK = 'slack'
    EMAIL = 'email'


COMMUNICATION_METHODS = (
    (CommunicationMethods.SLACK, 'Slack'),
    (CommunicationMethods.EMAIL, 'Email'),
)


class CommunicationType(Enum):
    TASK_STATUS_CHANGE = 0
    NEW_TASK_AVAILABLE = 1


def _add_communication_type(apps, schema_editor, communication_type):
    Worker = apps.get_model('orchestra', 'Worker')
    CommunicationPreference = apps.get_model('orchestra',
                                             'CommunicationPreference')
    for worker in Worker.objects.all():
        communication_preference, created = (
            CommunicationPreference.objects.get_or_create(
                worker=worker,
                communication_type=communication_type))

        # By default set both Slack and Email notifications to True
        if created:
            communication_preference.methods.slack = True
            communication_preference.methods.email = True
        communication_preference.save()
################# CommunicationType Migration Boilerplate Start ##########


def add_communication_type(apps, schema_editor):
    # Change this in future migrations to be the new CommunicationType you've
    # added.
    communication_type = (
        CommunicationType.NEW_TASK_AVAILABLE.value)
    _add_communication_type(apps, schema_editor, communication_type)


class Migration(migrations.Migration):

    dependencies = [
        ('orchestra', '0055_auto_20160429_0823'),
    ]

    operations = [
        migrations.RunPython(add_communication_type),  # manually-reviewed
    ]
