# -*- coding: utf-8 -*-
# **********************************************************************
#
# Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.4
#
# <auto-generated>
#
# Generated from file `IUpdate.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

from sys import version_info as _version_info_
import Ice, IcePy
import omero_cmd_API_ice
import omero_ServicesF_ice
import omero_Collections_ice

# Included module omero
_M_omero = Ice.openModule('omero')

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')

# Included module omero.model
_M_omero.model = Ice.openModule('omero.model')

# Included module omero.sys
_M_omero.sys = Ice.openModule('omero.sys')

# Included module omero.api
_M_omero.api = Ice.openModule('omero.api')

# Included module omero.cmd
_M_omero.cmd = Ice.openModule('omero.cmd')

# Included module omero.grid
_M_omero.grid = Ice.openModule('omero.grid')

# Start of module omero
__name__ = 'omero'

# Start of module omero.api
__name__ = 'omero.api'

if 'IUpdate' not in _M_omero.api.__dict__:
    _M_omero.api.IUpdate = Ice.createTempClass()
    class IUpdate(_M_omero.api.ServiceInterface):
        """
        Provides methods for directly updating object graphs. IUpdate is
        the lowest level (level-1) interface which may make changes
        (INSERT, UPDATE, DELETE) to the database. All other methods of
        changing the database may leave it in an inconsistent state.
        All the save* methods act recursively on the entire object graph,
        replacing placeholders and details where necessary, and then
        merging the final graph.
        This means that the objects that are passed into IUpdate.save*
        methods are copied over to new instances which are then returned.
        The original objects should be discarded.
        {@code saveAndReturnIds} behaves slightly differently in that
        it does not handle object modifications. The graph of
        objects passed in can consist ONLY if either newly created
        objects without ids or of unloaded objects with ids. Note:
        The ids of the saved values may not be in order. This is caused by
        persistence-by-transitivity. Hibernate may detect an item later in
        the array if they are interconnected and therefore choose to save
        it first.
        All methods throw omero.ValidationException if the input
        objects do not pass validation, and
        omero.OptimisticLockException if the version of a given has
        already been incremented.
        """
        def __init__(self):
            if Ice.getType(self) == _M_omero.api.IUpdate:
                raise RuntimeError('omero.api.IUpdate is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::omero::api::IUpdate', '::omero::api::ServiceInterface')

        def ice_id(self, current=None):
            return '::omero::api::IUpdate'

        def ice_staticId():
            return '::omero::api::IUpdate'
        ice_staticId = staticmethod(ice_staticId)

        def saveObject_async(self, _cb, obj, current=None):
            pass

        def saveCollection_async(self, _cb, objs, current=None):
            pass

        def saveAndReturnObject_async(self, _cb, obj, current=None):
            pass

        def saveArray_async(self, _cb, graph, current=None):
            pass

        def saveAndReturnArray_async(self, _cb, graph, current=None):
            pass

        def saveAndReturnIds_async(self, _cb, graph, current=None):
            pass

        def deleteObject_async(self, _cb, row, current=None):
            pass

        def indexObject_async(self, _cb, row, current=None):
            """
            Initiates full-text indexing for the given object. This may
            have to wait
            for the current {@code FullTextThread} to finish.
            Can only be executed by an admin. Other users must wait for
            the background Thread to complete.
            Arguments:
            _cb -- The asynchronous callback object.
            row -- a persistent omero.model.IObject to be deleted
            current -- The Current object for the invocation.
            Throws:
            ValidationException -- if the object does not exist or is nul
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_omero.api._t_IUpdate)

        __repr__ = __str__

    _M_omero.api.IUpdatePrx = Ice.createTempClass()
    class IUpdatePrx(_M_omero.api.ServiceInterfacePrx):

        def saveObject(self, obj, _ctx=None):
            return _M_omero.api.IUpdate._op_saveObject.invoke(self, ((obj, ), _ctx))

        def begin_saveObject(self, obj, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_saveObject.begin(self, ((obj, ), _response, _ex, _sent, _ctx))

        def end_saveObject(self, _r):
            return _M_omero.api.IUpdate._op_saveObject.end(self, _r)

        def saveCollection(self, objs, _ctx=None):
            return _M_omero.api.IUpdate._op_saveCollection.invoke(self, ((objs, ), _ctx))

        def begin_saveCollection(self, objs, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_saveCollection.begin(self, ((objs, ), _response, _ex, _sent, _ctx))

        def end_saveCollection(self, _r):
            return _M_omero.api.IUpdate._op_saveCollection.end(self, _r)

        def saveAndReturnObject(self, obj, _ctx=None):
            return _M_omero.api.IUpdate._op_saveAndReturnObject.invoke(self, ((obj, ), _ctx))

        def begin_saveAndReturnObject(self, obj, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_saveAndReturnObject.begin(self, ((obj, ), _response, _ex, _sent, _ctx))

        def end_saveAndReturnObject(self, _r):
            return _M_omero.api.IUpdate._op_saveAndReturnObject.end(self, _r)

        def saveArray(self, graph, _ctx=None):
            return _M_omero.api.IUpdate._op_saveArray.invoke(self, ((graph, ), _ctx))

        def begin_saveArray(self, graph, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_saveArray.begin(self, ((graph, ), _response, _ex, _sent, _ctx))

        def end_saveArray(self, _r):
            return _M_omero.api.IUpdate._op_saveArray.end(self, _r)

        def saveAndReturnArray(self, graph, _ctx=None):
            return _M_omero.api.IUpdate._op_saveAndReturnArray.invoke(self, ((graph, ), _ctx))

        def begin_saveAndReturnArray(self, graph, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_saveAndReturnArray.begin(self, ((graph, ), _response, _ex, _sent, _ctx))

        def end_saveAndReturnArray(self, _r):
            return _M_omero.api.IUpdate._op_saveAndReturnArray.end(self, _r)

        def saveAndReturnIds(self, graph, _ctx=None):
            return _M_omero.api.IUpdate._op_saveAndReturnIds.invoke(self, ((graph, ), _ctx))

        def begin_saveAndReturnIds(self, graph, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_saveAndReturnIds.begin(self, ((graph, ), _response, _ex, _sent, _ctx))

        def end_saveAndReturnIds(self, _r):
            return _M_omero.api.IUpdate._op_saveAndReturnIds.end(self, _r)

        def deleteObject(self, row, _ctx=None):
            return _M_omero.api.IUpdate._op_deleteObject.invoke(self, ((row, ), _ctx))

        def begin_deleteObject(self, row, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_deleteObject.begin(self, ((row, ), _response, _ex, _sent, _ctx))

        def end_deleteObject(self, _r):
            return _M_omero.api.IUpdate._op_deleteObject.end(self, _r)

        """
        Initiates full-text indexing for the given object. This may
        have to wait
        for the current {@code FullTextThread} to finish.
        Can only be executed by an admin. Other users must wait for
        the background Thread to complete.
        Arguments:
        row -- a persistent omero.model.IObject to be deleted
        _ctx -- The request context for the invocation.
        Throws:
        ValidationException -- if the object does not exist or is nul
        """
        def indexObject(self, row, _ctx=None):
            return _M_omero.api.IUpdate._op_indexObject.invoke(self, ((row, ), _ctx))

        """
        Initiates full-text indexing for the given object. This may
        have to wait
        for the current {@code FullTextThread} to finish.
        Can only be executed by an admin. Other users must wait for
        the background Thread to complete.
        Arguments:
        row -- a persistent omero.model.IObject to be deleted
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_indexObject(self, row, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_omero.api.IUpdate._op_indexObject.begin(self, ((row, ), _response, _ex, _sent, _ctx))

        """
        Initiates full-text indexing for the given object. This may
        have to wait
        for the current {@code FullTextThread} to finish.
        Can only be executed by an admin. Other users must wait for
        the background Thread to complete.
        Arguments:
        row -- a persistent omero.model.IObject to be deleted
        Throws:
        ValidationException -- if the object does not exist or is nul
        """
        def end_indexObject(self, _r):
            return _M_omero.api.IUpdate._op_indexObject.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_omero.api.IUpdatePrx.ice_checkedCast(proxy, '::omero::api::IUpdate', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_omero.api.IUpdatePrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::omero::api::IUpdate'
        ice_staticId = staticmethod(ice_staticId)

    _M_omero.api._t_IUpdatePrx = IcePy.defineProxy('::omero::api::IUpdate', IUpdatePrx)

    _M_omero.api._t_IUpdate = IcePy.defineClass('::omero::api::IUpdate', IUpdate, -1, (), True, False, None, (_M_omero.api._t_ServiceInterface,), ())
    IUpdate._ice_type = _M_omero.api._t_IUpdate

    IUpdate._op_saveObject = IcePy.Operation('saveObject', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_omero.model._t_IObject, False, 0),), (), None, (_M_omero._t_ServerError,))
    IUpdate._op_saveCollection = IcePy.Operation('saveCollection', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_omero.api._t_IObjectList, False, 0),), (), None, (_M_omero._t_ServerError,))
    IUpdate._op_saveAndReturnObject = IcePy.Operation('saveAndReturnObject', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_omero.model._t_IObject, False, 0),), (), ((), _M_omero.model._t_IObject, False, 0), (_M_omero._t_ServerError,))
    IUpdate._op_saveArray = IcePy.Operation('saveArray', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_omero.api._t_IObjectList, False, 0),), (), None, (_M_omero._t_ServerError,))
    IUpdate._op_saveAndReturnArray = IcePy.Operation('saveAndReturnArray', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_omero.api._t_IObjectList, False, 0),), (), ((), _M_omero.api._t_IObjectList, False, 0), (_M_omero._t_ServerError,))
    IUpdate._op_saveAndReturnIds = IcePy.Operation('saveAndReturnIds', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_omero.api._t_IObjectList, False, 0),), (), ((), _M_omero.sys._t_LongList, False, 0), (_M_omero._t_ServerError,))
    IUpdate._op_deleteObject = IcePy.Operation('deleteObject', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_omero.model._t_IObject, False, 0),), (), None, (_M_omero._t_ServerError,))
    IUpdate._op_deleteObject.deprecate("use omero::cmd::Delete2 instead")
    IUpdate._op_indexObject = IcePy.Operation('indexObject', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, True, None, (), (((), _M_omero.model._t_IObject, False, 0),), (), None, (_M_omero._t_ServerError,))

    _M_omero.api.IUpdate = IUpdate
    del IUpdate

    _M_omero.api.IUpdatePrx = IUpdatePrx
    del IUpdatePrx

if 'Save' not in _M_omero.api.__dict__:
    _M_omero.api.Save = Ice.createTempClass()
    class Save(_M_omero.cmd.Request):
        def __init__(self, obj=None):
            _M_omero.cmd.Request.__init__(self)
            self.obj = obj

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::omero::api::Save', '::omero::cmd::Request')

        def ice_id(self, current=None):
            return '::omero::api::Save'

        def ice_staticId():
            return '::omero::api::Save'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_omero.api._t_Save)

        __repr__ = __str__

    _M_omero.api.SavePrx = Ice.createTempClass()
    class SavePrx(_M_omero.cmd.RequestPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_omero.api.SavePrx.ice_checkedCast(proxy, '::omero::api::Save', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_omero.api.SavePrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::omero::api::Save'
        ice_staticId = staticmethod(ice_staticId)

    _M_omero.api._t_SavePrx = IcePy.defineProxy('::omero::api::Save', SavePrx)

    _M_omero.api._t_Save = IcePy.declareClass('::omero::api::Save')

    _M_omero.api._t_Save = IcePy.defineClass('::omero::api::Save', Save, -1, (), False, False, _M_omero.cmd._t_Request, (), (('obj', (), _M_omero.model._t_IObject, False, 0),))
    Save._ice_type = _M_omero.api._t_Save

    _M_omero.api.Save = Save
    del Save

    _M_omero.api.SavePrx = SavePrx
    del SavePrx

if 'SaveRsp' not in _M_omero.api.__dict__:
    _M_omero.api.SaveRsp = Ice.createTempClass()
    class SaveRsp(_M_omero.cmd.Response):
        def __init__(self, obj=None):
            _M_omero.cmd.Response.__init__(self)
            self.obj = obj

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::omero::api::SaveRsp', '::omero::cmd::Response')

        def ice_id(self, current=None):
            return '::omero::api::SaveRsp'

        def ice_staticId():
            return '::omero::api::SaveRsp'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_omero.api._t_SaveRsp)

        __repr__ = __str__

    _M_omero.api.SaveRspPrx = Ice.createTempClass()
    class SaveRspPrx(_M_omero.cmd.ResponsePrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_omero.api.SaveRspPrx.ice_checkedCast(proxy, '::omero::api::SaveRsp', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_omero.api.SaveRspPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::omero::api::SaveRsp'
        ice_staticId = staticmethod(ice_staticId)

    _M_omero.api._t_SaveRspPrx = IcePy.defineProxy('::omero::api::SaveRsp', SaveRspPrx)

    _M_omero.api._t_SaveRsp = IcePy.declareClass('::omero::api::SaveRsp')

    _M_omero.api._t_SaveRsp = IcePy.defineClass('::omero::api::SaveRsp', SaveRsp, -1, (), False, False, _M_omero.cmd._t_Response, (), (('obj', (), _M_omero.model._t_IObject, False, 0),))
    SaveRsp._ice_type = _M_omero.api._t_SaveRsp

    _M_omero.api.SaveRsp = SaveRsp
    del SaveRsp

    _M_omero.api.SaveRspPrx = SaveRspPrx
    del SaveRspPrx

# End of module omero.api

__name__ = 'omero'

# End of module omero
