# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['amortization']

package_data = \
{'': ['*']}

install_requires = \
['tabulate>=0.9.0,<0.10.0']

entry_points = \
{'console_scripts': ['amortize = amortization.amortize:main']}

setup_kwargs = {
    'name': 'amortization',
    'version': '2.2.1',
    'description': 'Python library for calculating amortizations and generating amortization schedules',
    'long_description': '<table>\n    <tr>\n        <td>License</td>\n        <td><img src=\'https://img.shields.io/pypi/l/amortization.svg?style=for-the-badge\' alt="License"></td>\n        <td>Version</td>\n        <td><img src=\'https://img.shields.io/pypi/v/amortization.svg?logo=pypi&style=for-the-badge\' alt="Version"></td>\n    </tr>\n    <tr>\n        <td>Github Actions</td>\n        <td><img src=\'https://img.shields.io/github/actions/workflow/status/roniemartinez/amortization/python.yml?branch=master&label=actions&logo=github%20actions&style=for-the-badge\' alt="Github Actions"></td>\n        <td>Coverage</td>\n        <td><img src=\'https://img.shields.io/codecov/c/github/roniemartinez/amortization/branch?label=codecov&logo=codecov&style=for-the-badge\' alt="CodeCov"></td>\n    </tr>\n    <tr>\n        <td>Supported versions</td>\n        <td><img src=\'https://img.shields.io/pypi/pyversions/amortization.svg?logo=python&style=for-the-badge\' alt="Python Versions"></td>\n        <td>Wheel</td>\n        <td><img src=\'https://img.shields.io/pypi/wheel/amortization.svg?style=for-the-badge\' alt="Wheel"></td>\n    </tr>\n    <tr>\n        <td>Status</td>\n        <td><img src=\'https://img.shields.io/pypi/status/amortization.svg?style=for-the-badge\' alt="Status"></td>\n        <td>Downloads</td>\n        <td><img src=\'https://img.shields.io/pypi/dm/amortization.svg?style=for-the-badge\' alt="Downloads"></td>\n    </tr>\n</table>\n\n# amortization\n\nPython library for calculating amortizations and generating amortization schedules\n\n## Installation\n\n```bash\npip install amortization\n```\n\n## Usage\n\n### Python\n\n#### Amortization Amount\n\n```python\nfrom amortization.amount import calculate_amortization_amount\n\namount = calculate_amortization_amount(150000, 0.1, 36)\n```\n\n#### Amortization Period\n\n```python\nfrom amortization.period import calculate_amortization_period\n\nperiod = calculate_amortization_period(150000, 0.1, 4840.08)\n```\n\n### Amortization Schedule\n\n```python\nfrom amortization.schedule import amortization_schedule\n\nfor number, amount, interest, principal, balance in amortization_schedule(150000, 0.1, 36):\n    print(number, amount, interest, principal, balance)\n```\n\n### Amortization Schedule (using tabulate)\n\n```python\nfrom amortization.schedule import amortization_schedule\nfrom tabulate import tabulate\n\ntable = (x for x in amortization_schedule(150000, 0.1, 36))\nprint(\n    tabulate(\n        table,\n        headers=["Number", "Amount", "Interest", "Principal", "Balance"],\n        floatfmt=",.2f",\n        numalign="right"\n    )\n)\n```\n\n### Command line\n\n```bash\namortize -h\nusage: amortize [-h] -P PRINCIPAL -r INTEREST_RATE [-s] (-n PERIOD | -a AMOUNT)\n\nPython library for calculating amortizations and generating amortization schedules\n\noptions:\n  -h, --help            show this help message and exit\n  -s, --schedule        Generate amortization schedule\n  -n PERIOD, --period PERIOD\n                        Total number of periods\n  -a AMOUNT, --amount AMOUNT\n                        Amortization amount per period\n\nrequired arguments:\n  -P PRINCIPAL, --principal PRINCIPAL\n                        Principal amount\n  -r INTEREST_RATE, --interest-rate INTEREST_RATE\n                        Interest rate per period\n```\n\n```bash\namortize -P 150000 -n 36 -r 0.1         # period\namortize -P 150000 -n 36 -r 0.1 -s      # schedule\namortize -P 150000 -a 4840.08 -r 0.1    # amount\n```\n\n```bash\n% amortize -P 150000 -n 36 -r 0.1 -s           \nNumber        Amount    Interest    Principal     Balance\n--------  ----------  ----------  -----------  ----------\n1           4,840.08    1,250.00     3,590.08  146,409.92\n2           4,840.08    1,220.08     3,620.00  142,789.92\n3           4,840.08    1,189.92     3,650.16  139,139.76\n4           4,840.08    1,159.50     3,680.58  135,459.18\n5           4,840.08    1,128.83     3,711.25  131,747.93\n6           4,840.08    1,097.90     3,742.18  128,005.75\n7           4,840.08    1,066.71     3,773.37  124,232.38\n8           4,840.08    1,035.27     3,804.81  120,427.57\n9           4,840.08    1,003.56     3,836.52  116,591.05\n10          4,840.08      971.59     3,868.49  112,722.56\n11          4,840.08      939.35     3,900.73  108,821.83\n12          4,840.08      906.85     3,933.23  104,888.60\n13          4,840.08      874.07     3,966.01  100,922.59\n14          4,840.08      841.02     3,999.06   96,923.53\n15          4,840.08      807.70     4,032.38   92,891.15\n16          4,840.08      774.09     4,065.99   88,825.16\n17          4,840.08      740.21     4,099.87   84,725.29\n18          4,840.08      706.04     4,134.04   80,591.25\n19          4,840.08      671.59     4,168.49   76,422.76\n20          4,840.08      636.86     4,203.22   72,219.54\n21          4,840.08      601.83     4,238.25   67,981.29\n22          4,840.08      566.51     4,273.57   63,707.72\n23          4,840.08      530.90     4,309.18   59,398.54\n24          4,840.08      494.99     4,345.09   55,053.45\n25          4,840.08      458.78     4,381.30   50,672.15\n26          4,840.08      422.27     4,417.81   46,254.34\n27          4,840.08      385.45     4,454.63   41,799.71\n28          4,840.08      348.33     4,491.75   37,307.96\n29          4,840.08      310.90     4,529.18   32,778.78\n30          4,840.08      273.16     4,566.92   28,211.86\n31          4,840.08      235.10     4,604.98   23,606.88\n32          4,840.08      196.72     4,643.36   18,963.52\n33          4,840.08      158.03     4,682.05   14,281.47\n34          4,840.08      119.01     4,721.07    9,560.40\n35          4,840.08       79.67     4,760.41    4,799.99\n36          4,839.99       40.00     4,799.99        0.00\nTotals    174,242.79   24,242.79   150,000.00\n```\n\n## Dependencies\n\n[tabulate](https://bitbucket.org/astanin/python-tabulate)\n\n## Author\n\n[Ronie Martinez](mailto:ronmarti18@gmail.com)\n\n## References\n\n- [Amortization Calculation Formula](https://www.vertex42.com/ExcelArticles/amortization-calculation.html)\n- [Amortization Period Formula](https://math.stackexchange.com/a/3185904)\n',
    'author': 'Ronie Martinez',
    'author_email': 'ronmarti18@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/roniemartinez/amortization',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
