/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dex.Leb128;
import com.android.dex.util.ByteOutput;
import com.android.dex.util.ExceptionWithContext;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.TwoColumnOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public final class ByteArrayAnnotatedOutput
implements AnnotatedOutput,
ByteOutput {
    private static final int DEFAULT_SIZE = 1000;
    private final boolean stretchy;
    private byte[] data;
    private int cursor;
    private boolean verbose;
    private ArrayList<Annotation> annotations;
    private int annotationWidth;
    private int hexCols;

    public ByteArrayAnnotatedOutput(byte[] byArray) {
        this(byArray, false);
    }

    public ByteArrayAnnotatedOutput() {
        this(1000);
    }

    public ByteArrayAnnotatedOutput(int n) {
        this(new byte[n], true);
    }

    private ByteArrayAnnotatedOutput(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("data == null");
        }
        this.stretchy = bl;
        this.data = byArray;
        this.cursor = 0;
        this.verbose = false;
        this.annotations = null;
        this.annotationWidth = 0;
        this.hexCols = 0;
    }

    public byte[] getArray() {
        return this.data;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.cursor];
        System.arraycopy(this.data, 0, byArray, 0, this.cursor);
        return byArray;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public void assertCursor(int n) {
        if (this.cursor != n) {
            throw new ExceptionWithContext("expected cursor " + n + "; actual value: " + this.cursor);
        }
    }

    @Override
    public void writeByte(int n) {
        int n2 = this.cursor;
        int n3 = n2 + 1;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.data[n2] = (byte)n;
        this.cursor = n3;
    }

    @Override
    public void writeShort(int n) {
        int n2 = this.cursor;
        int n3 = n2 + 2;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.data[n2] = (byte)n;
        this.data[n2 + 1] = (byte)(n >> 8);
        this.cursor = n3;
    }

    @Override
    public void writeInt(int n) {
        int n2 = this.cursor;
        int n3 = n2 + 4;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.data[n2] = (byte)n;
        this.data[n2 + 1] = (byte)(n >> 8);
        this.data[n2 + 2] = (byte)(n >> 16);
        this.data[n2 + 3] = (byte)(n >> 24);
        this.cursor = n3;
    }

    @Override
    public void writeLong(long l) {
        int n = this.cursor;
        int n2 = n + 8;
        if (this.stretchy) {
            this.ensureCapacity(n2);
        } else if (n2 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        int n3 = (int)l;
        this.data[n] = (byte)n3;
        this.data[n + 1] = (byte)(n3 >> 8);
        this.data[n + 2] = (byte)(n3 >> 16);
        this.data[n + 3] = (byte)(n3 >> 24);
        n3 = (int)(l >> 32);
        this.data[n + 4] = (byte)n3;
        this.data[n + 5] = (byte)(n3 >> 8);
        this.data[n + 6] = (byte)(n3 >> 16);
        this.data[n + 7] = (byte)(n3 >> 24);
        this.cursor = n2;
    }

    @Override
    public int writeUleb128(int n) {
        if (this.stretchy) {
            this.ensureCapacity(this.cursor + 5);
        }
        int n2 = this.cursor;
        Leb128.writeUnsignedLeb128(this, n);
        return this.cursor - n2;
    }

    @Override
    public int writeSleb128(int n) {
        if (this.stretchy) {
            this.ensureCapacity(this.cursor + 5);
        }
        int n2 = this.cursor;
        Leb128.writeSignedLeb128(this, n);
        return this.cursor - n2;
    }

    @Override
    public void write(ByteArray byteArray) {
        int n = byteArray.size();
        int n2 = this.cursor;
        int n3 = n2 + n;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        byteArray.getBytes(this.data, n2);
        this.cursor = n3;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        int n3 = this.cursor;
        int n4 = n3 + n2;
        int n5 = n + n2;
        if ((n | n2 | n4) < 0 || n5 > byArray.length) {
            throw new IndexOutOfBoundsException("bytes.length " + byArray.length + "; " + n + "..!" + n4);
        }
        if (this.stretchy) {
            this.ensureCapacity(n4);
        } else if (n4 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        System.arraycopy(byArray, n, this.data, n3, n2);
        this.cursor = n4;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void writeZeroes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        int n2 = this.cursor + n;
        if (this.stretchy) {
            this.ensureCapacity(n2);
        } else if (n2 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.cursor = n2;
    }

    @Override
    public void alignTo(int n) {
        int n2 = n - 1;
        if (n < 0 || (n2 & n) != 0) {
            throw new IllegalArgumentException("bogus alignment");
        }
        int n3 = this.cursor + n2 & ~n2;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.cursor = n3;
    }

    @Override
    public boolean annotates() {
        return this.annotations != null;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void annotate(String string) {
        if (this.annotations == null) {
            return;
        }
        this.endAnnotation();
        this.annotations.add(new Annotation(this.cursor, string));
    }

    @Override
    public void annotate(int n, String string) {
        if (this.annotations == null) {
            return;
        }
        this.endAnnotation();
        int n2 = this.annotations.size();
        int n3 = n2 == 0 ? 0 : this.annotations.get(n2 - 1).getEnd();
        int n4 = n3 <= this.cursor ? this.cursor : n3;
        this.annotations.add(new Annotation(n4, n4 + n, string));
    }

    @Override
    public void endAnnotation() {
        if (this.annotations == null) {
            return;
        }
        int n = this.annotations.size();
        if (n != 0) {
            this.annotations.get(n - 1).setEndIfUnset(this.cursor);
        }
    }

    @Override
    public int getAnnotationWidth() {
        int n = 8 + this.hexCols * 2 + this.hexCols / 2;
        return this.annotationWidth - n;
    }

    public void enableAnnotations(int n, boolean bl) {
        if (this.annotations != null || this.cursor != 0) {
            throw new RuntimeException("cannot enable annotations");
        }
        if (n < 40) {
            throw new IllegalArgumentException("annotationWidth < 40");
        }
        int n2 = (n - 7) / 15 + 1 & 0xFFFFFFFE;
        if (n2 < 6) {
            n2 = 6;
        } else if (n2 > 10) {
            n2 = 10;
        }
        this.annotations = new ArrayList(1000);
        this.annotationWidth = n;
        this.hexCols = n2;
        this.verbose = bl;
    }

    public void finishAnnotating() {
        this.endAnnotation();
        if (this.annotations != null) {
            for (int i = this.annotations.size(); i > 0; --i) {
                Annotation annotation = this.annotations.get(i - 1);
                if (annotation.getStart() > this.cursor) {
                    this.annotations.remove(i - 1);
                    continue;
                }
                if (annotation.getEnd() <= this.cursor) break;
                annotation.setEnd(this.cursor);
                break;
            }
        }
    }

    public void writeAnnotationsTo(Writer writer) throws IOException {
        int n = this.getAnnotationWidth();
        int n2 = this.annotationWidth - n - 1;
        TwoColumnOutput twoColumnOutput = new TwoColumnOutput(writer, n2, n, "|");
        Writer writer2 = twoColumnOutput.getLeft();
        Writer writer3 = twoColumnOutput.getRight();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.annotations.size();
        while (n3 < this.cursor && n4 < n5) {
            String string;
            int n6;
            Annotation annotation = this.annotations.get(n4);
            int n7 = annotation.getStart();
            if (n3 < n7) {
                n6 = n7;
                n7 = n3;
                string = "";
            } else {
                n6 = annotation.getEnd();
                string = annotation.getText();
                ++n4;
            }
            writer2.write(Hex.dump(this.data, n7, n6 - n7, n7, this.hexCols, 6));
            writer3.write(string);
            twoColumnOutput.flush();
            n3 = n6;
        }
        if (n3 < this.cursor) {
            writer2.write(Hex.dump(this.data, n3, this.cursor - n3, n3, this.hexCols, 6));
        }
        while (n4 < n5) {
            writer3.write(this.annotations.get(n4).getText());
            ++n4;
        }
        twoColumnOutput.flush();
    }

    private static void throwBounds() {
        throw new IndexOutOfBoundsException("attempt to write past the end");
    }

    private void ensureCapacity(int n) {
        if (this.data.length < n) {
            byte[] byArray = new byte[n * 2 + 1000];
            System.arraycopy(this.data, 0, byArray, 0, this.cursor);
            this.data = byArray;
        }
    }

    private static class Annotation {
        private final int start;
        private int end;
        private final String text;

        public Annotation(int n, int n2, String string) {
            this.start = n;
            this.end = n2;
            this.text = string;
        }

        public Annotation(int n, String string) {
            this(n, Integer.MAX_VALUE, string);
        }

        public void setEndIfUnset(int n) {
            if (this.end == Integer.MAX_VALUE) {
                this.end = n;
            }
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getText() {
            return this.text;
        }
    }
}

