/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.LocalVariableInfo;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.util.Bits;
import com.android.dx.util.IntList;

public final class LocalVariableExtractor {
    private final RopMethod method;
    private final BasicBlockList blocks;
    private final LocalVariableInfo resultInfo;
    private final int[] workSet;

    public static LocalVariableInfo extract(RopMethod ropMethod) {
        LocalVariableExtractor localVariableExtractor = new LocalVariableExtractor(ropMethod);
        return localVariableExtractor.doit();
    }

    private LocalVariableExtractor(RopMethod ropMethod) {
        if (ropMethod == null) {
            throw new NullPointerException("method == null");
        }
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int n = basicBlockList.getMaxLabel();
        this.method = ropMethod;
        this.blocks = basicBlockList;
        this.resultInfo = new LocalVariableInfo(ropMethod);
        this.workSet = Bits.makeBitSet(n);
    }

    private LocalVariableInfo doit() {
        int n = this.method.getFirstLabel();
        while (n >= 0) {
            Bits.clear(this.workSet, n);
            this.processBlock(n);
            n = Bits.findFirst(this.workSet, 0);
        }
        this.resultInfo.setImmutable();
        return this.resultInfo;
    }

    private void processBlock(int n) {
        RegisterSpecSet registerSpecSet = this.resultInfo.mutableCopyOfStarts(n);
        BasicBlock basicBlock = this.blocks.labelToBlock(n);
        InsnList insnList = basicBlock.getInsns();
        int n2 = insnList.size();
        boolean bl = basicBlock.hasExceptionHandlers() && insnList.getLast().getResult() != null;
        int n3 = n2 - 1;
        RegisterSpecSet registerSpecSet2 = registerSpecSet;
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec;
            Insn insn;
            RegisterSpec registerSpec2;
            if (bl && i == n3) {
                registerSpecSet.setImmutable();
                registerSpecSet = registerSpecSet.mutableCopy();
            }
            if ((registerSpec2 = (insn = insnList.get(i)).getLocalAssignment()) == null) {
                registerSpec2 = insn.getResult();
                if (registerSpec2 == null || registerSpecSet.get(registerSpec2.getReg()) == null) continue;
                registerSpecSet.remove(registerSpecSet.get(registerSpec2.getReg()));
                continue;
            }
            if ((registerSpec2 = registerSpec2.withSimpleType()).equals(registerSpec = registerSpecSet.get(registerSpec2))) continue;
            RegisterSpec registerSpec3 = registerSpecSet.localItemToSpec(registerSpec2.getLocalItem());
            if (registerSpec3 != null && registerSpec3.getReg() != registerSpec2.getReg()) {
                registerSpecSet.remove(registerSpec3);
            }
            this.resultInfo.addAssignment(insn, registerSpec2);
            registerSpecSet.put(registerSpec2);
        }
        registerSpecSet.setImmutable();
        IntList intList = basicBlock.getSuccessors();
        int n4 = intList.size();
        int n5 = basicBlock.getPrimarySuccessor();
        for (int i = 0; i < n4; ++i) {
            RegisterSpecSet registerSpecSet3;
            int n6 = intList.get(i);
            RegisterSpecSet registerSpecSet4 = registerSpecSet3 = n6 == n5 ? registerSpecSet : registerSpecSet2;
            if (!this.resultInfo.mergeStarts(n6, registerSpecSet3)) continue;
            Bits.set(this.workSet, n6);
        }
    }
}

