/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.EncodedValueCodec;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.StringIdsSection;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.NameValuePair;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstAnnotation;
import com.android.dx.rop.cst.CstArray;
import com.android.dx.rop.cst.CstBoolean;
import com.android.dx.rop.cst.CstByte;
import com.android.dx.rop.cst.CstChar;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstEnumRef;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstKnownNull;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstShort;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.Collection;

public final class ValueEncoder {
    private static final int VALUE_BYTE = 0;
    private static final int VALUE_SHORT = 2;
    private static final int VALUE_CHAR = 3;
    private static final int VALUE_INT = 4;
    private static final int VALUE_LONG = 6;
    private static final int VALUE_FLOAT = 16;
    private static final int VALUE_DOUBLE = 17;
    private static final int VALUE_STRING = 23;
    private static final int VALUE_TYPE = 24;
    private static final int VALUE_FIELD = 25;
    private static final int VALUE_METHOD = 26;
    private static final int VALUE_ENUM = 27;
    private static final int VALUE_ARRAY = 28;
    private static final int VALUE_ANNOTATION = 29;
    private static final int VALUE_NULL = 30;
    private static final int VALUE_BOOLEAN = 31;
    private final DexFile file;
    private final AnnotatedOutput out;

    public ValueEncoder(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        if (dexFile == null) {
            throw new NullPointerException("file == null");
        }
        if (annotatedOutput == null) {
            throw new NullPointerException("out == null");
        }
        this.file = dexFile;
        this.out = annotatedOutput;
    }

    public void writeConstant(Constant constant) {
        int n = ValueEncoder.constantToValueType(constant);
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                long l = ((CstLiteralBits)constant).getLongBits();
                EncodedValueCodec.writeSignedIntegralValue(this.out, n, l);
                break;
            }
            case 3: {
                long l = ((CstLiteralBits)constant).getLongBits();
                EncodedValueCodec.writeUnsignedIntegralValue(this.out, n, l);
                break;
            }
            case 16: {
                long l = ((CstFloat)constant).getLongBits() << 32;
                EncodedValueCodec.writeRightZeroExtendedValue(this.out, n, l);
                break;
            }
            case 17: {
                long l = ((CstDouble)constant).getLongBits();
                EncodedValueCodec.writeRightZeroExtendedValue(this.out, n, l);
                break;
            }
            case 23: {
                int n2 = this.file.getStringIds().indexOf((CstString)constant);
                EncodedValueCodec.writeUnsignedIntegralValue(this.out, n, n2);
                break;
            }
            case 24: {
                int n3 = this.file.getTypeIds().indexOf((CstType)constant);
                EncodedValueCodec.writeUnsignedIntegralValue(this.out, n, n3);
                break;
            }
            case 25: {
                int n4 = this.file.getFieldIds().indexOf((CstFieldRef)constant);
                EncodedValueCodec.writeUnsignedIntegralValue(this.out, n, n4);
                break;
            }
            case 26: {
                int n5 = this.file.getMethodIds().indexOf((CstMethodRef)constant);
                EncodedValueCodec.writeUnsignedIntegralValue(this.out, n, n5);
                break;
            }
            case 27: {
                CstFieldRef cstFieldRef = ((CstEnumRef)constant).getFieldRef();
                int n6 = this.file.getFieldIds().indexOf(cstFieldRef);
                EncodedValueCodec.writeUnsignedIntegralValue(this.out, n, n6);
                break;
            }
            case 28: {
                this.out.writeByte(n);
                this.writeArray((CstArray)constant, false);
                break;
            }
            case 29: {
                this.out.writeByte(n);
                this.writeAnnotation(((CstAnnotation)constant).getAnnotation(), false);
                break;
            }
            case 30: {
                this.out.writeByte(n);
                break;
            }
            case 31: {
                int n7 = ((CstBoolean)constant).getIntBits();
                this.out.writeByte(n | n7 << 5);
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't happen");
            }
        }
    }

    private static int constantToValueType(Constant constant) {
        if (constant instanceof CstByte) {
            return 0;
        }
        if (constant instanceof CstShort) {
            return 2;
        }
        if (constant instanceof CstChar) {
            return 3;
        }
        if (constant instanceof CstInteger) {
            return 4;
        }
        if (constant instanceof CstLong) {
            return 6;
        }
        if (constant instanceof CstFloat) {
            return 16;
        }
        if (constant instanceof CstDouble) {
            return 17;
        }
        if (constant instanceof CstString) {
            return 23;
        }
        if (constant instanceof CstType) {
            return 24;
        }
        if (constant instanceof CstFieldRef) {
            return 25;
        }
        if (constant instanceof CstMethodRef) {
            return 26;
        }
        if (constant instanceof CstEnumRef) {
            return 27;
        }
        if (constant instanceof CstArray) {
            return 28;
        }
        if (constant instanceof CstAnnotation) {
            return 29;
        }
        if (constant instanceof CstKnownNull) {
            return 30;
        }
        if (constant instanceof CstBoolean) {
            return 31;
        }
        throw new RuntimeException("Shouldn't happen");
    }

    public void writeArray(CstArray cstArray, boolean bl) {
        boolean bl2 = bl && this.out.annotates();
        CstArray.List list = cstArray.getList();
        int n = list.size();
        if (bl2) {
            this.out.annotate("  size: " + Hex.u4(n));
        }
        this.out.writeUleb128(n);
        for (int i = 0; i < n; ++i) {
            Constant constant = list.get(i);
            if (bl2) {
                this.out.annotate("  [" + Integer.toHexString(i) + "] " + ValueEncoder.constantToHuman(constant));
            }
            this.writeConstant(constant);
        }
        if (bl2) {
            this.out.endAnnotation();
        }
    }

    public void writeAnnotation(Annotation annotation, boolean bl) {
        boolean bl2 = bl && this.out.annotates();
        StringIdsSection stringIdsSection = this.file.getStringIds();
        TypeIdsSection typeIdsSection = this.file.getTypeIds();
        CstType cstType = annotation.getType();
        int n = typeIdsSection.indexOf(cstType);
        if (bl2) {
            this.out.annotate("  type_idx: " + Hex.u4(n) + " // " + cstType.toHuman());
        }
        this.out.writeUleb128(typeIdsSection.indexOf(annotation.getType()));
        Collection<NameValuePair> collection = annotation.getNameValuePairs();
        int n2 = collection.size();
        if (bl2) {
            this.out.annotate("  size: " + Hex.u4(n2));
        }
        this.out.writeUleb128(n2);
        int n3 = 0;
        for (NameValuePair nameValuePair : collection) {
            CstString cstString = nameValuePair.getName();
            int n4 = stringIdsSection.indexOf(cstString);
            Constant constant = nameValuePair.getValue();
            if (bl2) {
                this.out.annotate(0, "  elements[" + n3 + "]:");
                ++n3;
                this.out.annotate("    name_idx: " + Hex.u4(n4) + " // " + cstString.toHuman());
            }
            this.out.writeUleb128(n4);
            if (bl2) {
                this.out.annotate("    value: " + ValueEncoder.constantToHuman(constant));
            }
            this.writeConstant(constant);
        }
        if (bl2) {
            this.out.endAnnotation();
        }
    }

    public static String constantToHuman(Constant constant) {
        int n = ValueEncoder.constantToValueType(constant);
        if (n == 30) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(constant.typeName());
        stringBuilder.append(' ');
        stringBuilder.append(constant.toHuman());
        return stringBuilder.toString();
    }

    public static void addContents(DexFile dexFile, Annotation annotation) {
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        StringIdsSection stringIdsSection = dexFile.getStringIds();
        typeIdsSection.intern(annotation.getType());
        for (NameValuePair nameValuePair : annotation.getNameValuePairs()) {
            stringIdsSection.intern(nameValuePair.getName());
            ValueEncoder.addContents(dexFile, nameValuePair.getValue());
        }
    }

    public static void addContents(DexFile dexFile, Constant constant) {
        if (constant instanceof CstAnnotation) {
            ValueEncoder.addContents(dexFile, ((CstAnnotation)constant).getAnnotation());
        } else if (constant instanceof CstArray) {
            CstArray.List list = ((CstArray)constant).getList();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ValueEncoder.addContents(dexFile, list.get(i));
            }
        } else {
            dexFile.internIfAppropriate(constant);
        }
    }
}

