/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.AnnotationsDirectoryItem;
import com.android.dx.dex.file.ClassDataItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedArrayItem;
import com.android.dx.dex.file.EncodedField;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.StringIdsSection;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.dex.file.TypeListItem;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstArray;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import com.android.dx.util.Writers;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public final class ClassDefItem
extends IndexedItem {
    private final CstType thisClass;
    private final int accessFlags;
    private final CstType superclass;
    private TypeListItem interfaces;
    private final CstString sourceFile;
    private final ClassDataItem classData;
    private EncodedArrayItem staticValuesItem;
    private AnnotationsDirectoryItem annotationsDirectory;

    public ClassDefItem(CstType cstType, int n, CstType cstType2, TypeList typeList, CstString cstString) {
        if (cstType == null) {
            throw new NullPointerException("thisClass == null");
        }
        if (typeList == null) {
            throw new NullPointerException("interfaces == null");
        }
        this.thisClass = cstType;
        this.accessFlags = n;
        this.superclass = cstType2;
        this.interfaces = typeList.size() == 0 ? null : new TypeListItem(typeList);
        this.sourceFile = cstString;
        this.classData = new ClassDataItem(cstType);
        this.staticValuesItem = null;
        this.annotationsDirectory = new AnnotationsDirectoryItem();
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_CLASS_DEF_ITEM;
    }

    @Override
    public int writeSize() {
        return 32;
    }

    @Override
    public void addContents(DexFile dexFile) {
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        MixedItemSection mixedItemSection = dexFile.getByteData();
        MixedItemSection mixedItemSection2 = dexFile.getWordData();
        MixedItemSection mixedItemSection3 = dexFile.getTypeLists();
        StringIdsSection stringIdsSection = dexFile.getStringIds();
        typeIdsSection.intern(this.thisClass);
        if (!this.classData.isEmpty()) {
            MixedItemSection mixedItemSection4 = dexFile.getClassData();
            mixedItemSection4.add(this.classData);
            CstArray cstArray = this.classData.getStaticValuesConstant();
            if (cstArray != null) {
                this.staticValuesItem = mixedItemSection.intern(new EncodedArrayItem(cstArray));
            }
        }
        if (this.superclass != null) {
            typeIdsSection.intern(this.superclass);
        }
        if (this.interfaces != null) {
            this.interfaces = mixedItemSection3.intern(this.interfaces);
        }
        if (this.sourceFile != null) {
            stringIdsSection.intern(this.sourceFile);
        }
        if (!this.annotationsDirectory.isEmpty()) {
            if (this.annotationsDirectory.isInternable()) {
                this.annotationsDirectory = mixedItemSection2.intern(this.annotationsDirectory);
            } else {
                mixedItemSection2.add(this.annotationsDirectory);
            }
        }
    }

    @Override
    public void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        boolean bl = annotatedOutput.annotates();
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        int n = typeIdsSection.indexOf(this.thisClass);
        int n2 = this.superclass == null ? -1 : typeIdsSection.indexOf(this.superclass);
        int n3 = OffsettedItem.getAbsoluteOffsetOr0(this.interfaces);
        int n4 = this.annotationsDirectory.isEmpty() ? 0 : this.annotationsDirectory.getAbsoluteOffset();
        int n5 = this.sourceFile == null ? -1 : dexFile.getStringIds().indexOf(this.sourceFile);
        int n6 = this.classData.isEmpty() ? 0 : this.classData.getAbsoluteOffset();
        int n7 = OffsettedItem.getAbsoluteOffsetOr0(this.staticValuesItem);
        if (bl) {
            annotatedOutput.annotate(0, this.indexString() + ' ' + this.thisClass.toHuman());
            annotatedOutput.annotate(4, "  class_idx:           " + Hex.u4(n));
            annotatedOutput.annotate(4, "  access_flags:        " + AccessFlags.classString(this.accessFlags));
            annotatedOutput.annotate(4, "  superclass_idx:      " + Hex.u4(n2) + " // " + (this.superclass == null ? "<none>" : this.superclass.toHuman()));
            annotatedOutput.annotate(4, "  interfaces_off:      " + Hex.u4(n3));
            if (n3 != 0) {
                TypeList typeList = this.interfaces.getList();
                int n8 = typeList.size();
                for (int i = 0; i < n8; ++i) {
                    annotatedOutput.annotate(0, "    " + typeList.getType(i).toHuman());
                }
            }
            annotatedOutput.annotate(4, "  source_file_idx:     " + Hex.u4(n5) + " // " + (this.sourceFile == null ? "<none>" : this.sourceFile.toHuman()));
            annotatedOutput.annotate(4, "  annotations_off:     " + Hex.u4(n4));
            annotatedOutput.annotate(4, "  class_data_off:      " + Hex.u4(n6));
            annotatedOutput.annotate(4, "  static_values_off:   " + Hex.u4(n7));
        }
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(this.accessFlags);
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n3);
        annotatedOutput.writeInt(n5);
        annotatedOutput.writeInt(n4);
        annotatedOutput.writeInt(n6);
        annotatedOutput.writeInt(n7);
    }

    public CstType getThisClass() {
        return this.thisClass;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public CstType getSuperclass() {
        return this.superclass;
    }

    public TypeList getInterfaces() {
        if (this.interfaces == null) {
            return StdTypeList.EMPTY;
        }
        return this.interfaces.getList();
    }

    public CstString getSourceFile() {
        return this.sourceFile;
    }

    public void addStaticField(EncodedField encodedField, Constant constant) {
        this.classData.addStaticField(encodedField, constant);
    }

    public void addInstanceField(EncodedField encodedField) {
        this.classData.addInstanceField(encodedField);
    }

    public void addDirectMethod(EncodedMethod encodedMethod) {
        this.classData.addDirectMethod(encodedMethod);
    }

    public void addVirtualMethod(EncodedMethod encodedMethod) {
        this.classData.addVirtualMethod(encodedMethod);
    }

    public ArrayList<EncodedMethod> getMethods() {
        return this.classData.getMethods();
    }

    public void setClassAnnotations(Annotations annotations, DexFile dexFile) {
        this.annotationsDirectory.setClassAnnotations(annotations, dexFile);
    }

    public void addFieldAnnotations(CstFieldRef cstFieldRef, Annotations annotations, DexFile dexFile) {
        this.annotationsDirectory.addFieldAnnotations(cstFieldRef, annotations, dexFile);
    }

    public void addMethodAnnotations(CstMethodRef cstMethodRef, Annotations annotations, DexFile dexFile) {
        this.annotationsDirectory.addMethodAnnotations(cstMethodRef, annotations, dexFile);
    }

    public void addParameterAnnotations(CstMethodRef cstMethodRef, AnnotationsList annotationsList, DexFile dexFile) {
        this.annotationsDirectory.addParameterAnnotations(cstMethodRef, annotationsList, dexFile);
    }

    public Annotations getMethodAnnotations(CstMethodRef cstMethodRef) {
        return this.annotationsDirectory.getMethodAnnotations(cstMethodRef);
    }

    public AnnotationsList getParameterAnnotations(CstMethodRef cstMethodRef) {
        return this.annotationsDirectory.getParameterAnnotations(cstMethodRef);
    }

    public void debugPrint(Writer writer, boolean bl) {
        PrintWriter printWriter = Writers.printWriterFor(writer);
        printWriter.println(this.getClass().getName() + " {");
        printWriter.println("  accessFlags: " + Hex.u2(this.accessFlags));
        printWriter.println("  superclass: " + this.superclass);
        printWriter.println("  interfaces: " + (this.interfaces == null ? "<none>" : this.interfaces));
        printWriter.println("  sourceFile: " + (this.sourceFile == null ? "<none>" : this.sourceFile.toQuoted()));
        this.classData.debugPrint(writer, bl);
        this.annotationsDirectory.debugPrint(printWriter);
        printWriter.println("}");
    }
}

