/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.HighRegisterPrefix;
import com.android.dx.dex.code.SimpleInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import com.android.dx.util.TwoColumnOutput;
import java.util.BitSet;

public abstract class DalvInsn {
    private int address;
    private final Dop opcode;
    private final SourcePosition position;
    private final RegisterSpecList registers;

    public static SimpleInsn makeMove(SourcePosition sourcePosition, RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        boolean bl = registerSpec.getCategory() == 1;
        boolean bl2 = registerSpec.getType().isReference();
        int n = registerSpec.getReg();
        int n2 = registerSpec2.getReg();
        Dop dop = (n2 | n) < 16 ? (bl2 ? Dops.MOVE_OBJECT : (bl ? Dops.MOVE : Dops.MOVE_WIDE)) : (n < 256 ? (bl2 ? Dops.MOVE_OBJECT_FROM16 : (bl ? Dops.MOVE_FROM16 : Dops.MOVE_WIDE_FROM16)) : (bl2 ? Dops.MOVE_OBJECT_16 : (bl ? Dops.MOVE_16 : Dops.MOVE_WIDE_16)));
        return new SimpleInsn(dop, sourcePosition, RegisterSpecList.make(registerSpec, registerSpec2));
    }

    public DalvInsn(Dop dop, SourcePosition sourcePosition, RegisterSpecList registerSpecList) {
        if (dop == null) {
            throw new NullPointerException("opcode == null");
        }
        if (sourcePosition == null) {
            throw new NullPointerException("position == null");
        }
        if (registerSpecList == null) {
            throw new NullPointerException("registers == null");
        }
        this.address = -1;
        this.opcode = dop;
        this.position = sourcePosition;
        this.registers = registerSpecList;
    }

    public final String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.identifierString());
        stringBuffer.append(' ');
        stringBuffer.append(this.position);
        stringBuffer.append(": ");
        stringBuffer.append(this.opcode.getName());
        boolean bl = false;
        if (this.registers.size() != 0) {
            stringBuffer.append(this.registers.toHuman(" ", ", ", null));
            bl = true;
        }
        if ((string = this.argString()) != null) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public final boolean hasAddress() {
        return this.address >= 0;
    }

    public final int getAddress() {
        if (this.address < 0) {
            throw new RuntimeException("address not yet known");
        }
        return this.address;
    }

    public final Dop getOpcode() {
        return this.opcode;
    }

    public final SourcePosition getPosition() {
        return this.position;
    }

    public final RegisterSpecList getRegisters() {
        return this.registers;
    }

    public final boolean hasResult() {
        return this.opcode.hasResult();
    }

    public final int getMinimumRegisterRequirement(BitSet bitSet) {
        int n;
        boolean bl = this.hasResult();
        int n2 = this.registers.size();
        int n3 = 0;
        int n4 = 0;
        if (bl && !bitSet.get(0)) {
            n3 = this.registers.get(0).getCategory();
        }
        int n5 = n = bl ? 1 : 0;
        while (n < n2) {
            if (!bitSet.get(n)) {
                n4 += this.registers.get(n).getCategory();
            }
            ++n;
        }
        return Math.max(n4, n3);
    }

    public DalvInsn getLowRegVersion() {
        RegisterSpecList registerSpecList = this.registers.withExpandedRegisters(0, this.hasResult(), null);
        return this.withRegisters(registerSpecList);
    }

    public DalvInsn expandedPrefix(BitSet bitSet) {
        RegisterSpecList registerSpecList = this.registers;
        boolean bl = bitSet.get(0);
        if (this.hasResult()) {
            bitSet.set(0);
        }
        registerSpecList = registerSpecList.subset(bitSet);
        if (this.hasResult()) {
            bitSet.set(0, bl);
        }
        if (registerSpecList.size() == 0) {
            return null;
        }
        return new HighRegisterPrefix(this.position, registerSpecList);
    }

    public DalvInsn expandedSuffix(BitSet bitSet) {
        if (this.hasResult() && !bitSet.get(0)) {
            RegisterSpec registerSpec = this.registers.get(0);
            return DalvInsn.makeMove(this.position, registerSpec, registerSpec.withReg(0));
        }
        return null;
    }

    public DalvInsn expandedVersion(BitSet bitSet) {
        RegisterSpecList registerSpecList = this.registers.withExpandedRegisters(0, this.hasResult(), bitSet);
        return this.withRegisters(registerSpecList);
    }

    public final String identifierString() {
        if (this.address != -1) {
            return String.format("%04x", this.address);
        }
        return Hex.u4(System.identityHashCode(this));
    }

    public final String listingString(String string, int n, boolean bl) {
        String string2 = this.listingString0(bl);
        if (string2 == null) {
            return null;
        }
        String string3 = string + this.identifierString() + ": ";
        int n2 = string3.length();
        int n3 = n == 0 ? string2.length() : n - n2;
        return TwoColumnOutput.toString(string3, n2, "", string2, n3);
    }

    public final void setAddress(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("address < 0");
        }
        this.address = n;
    }

    public final int getNextAddress() {
        return this.getAddress() + this.codeSize();
    }

    public DalvInsn withMapper(RegisterMapper registerMapper) {
        return this.withRegisters(registerMapper.map(this.getRegisters()));
    }

    public abstract int codeSize();

    public abstract void writeTo(AnnotatedOutput var1);

    public abstract DalvInsn withOpcode(Dop var1);

    public abstract DalvInsn withRegisterOffset(int var1);

    public abstract DalvInsn withRegisters(RegisterSpecList var1);

    protected abstract String argString();

    protected abstract String listingString0(boolean var1);
}

