/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.attrib.AttAnnotationDefault;
import com.android.dx.cf.attrib.AttCode;
import com.android.dx.cf.attrib.AttConstantValue;
import com.android.dx.cf.attrib.AttDeprecated;
import com.android.dx.cf.attrib.AttEnclosingMethod;
import com.android.dx.cf.attrib.AttExceptions;
import com.android.dx.cf.attrib.AttInnerClasses;
import com.android.dx.cf.attrib.AttLineNumberTable;
import com.android.dx.cf.attrib.AttLocalVariableTable;
import com.android.dx.cf.attrib.AttLocalVariableTypeTable;
import com.android.dx.cf.attrib.AttRuntimeInvisibleAnnotations;
import com.android.dx.cf.attrib.AttRuntimeInvisibleParameterAnnotations;
import com.android.dx.cf.attrib.AttRuntimeVisibleAnnotations;
import com.android.dx.cf.attrib.AttRuntimeVisibleParameterAnnotations;
import com.android.dx.cf.attrib.AttSignature;
import com.android.dx.cf.attrib.AttSourceFile;
import com.android.dx.cf.attrib.AttSynthetic;
import com.android.dx.cf.attrib.InnerClassList;
import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.LineNumberList;
import com.android.dx.cf.code.LocalVariableList;
import com.android.dx.cf.direct.AnnotationParser;
import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.AttributeListParser;
import com.android.dx.cf.direct.CodeObserver;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.Attribute;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.cf.iface.StdAttributeList;
import com.android.dx.rop.annotation.AnnotationVisibility;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import java.io.IOException;

public class StdAttributeFactory
extends AttributeFactory {
    public static final StdAttributeFactory THE_ONE = new StdAttributeFactory();

    @Override
    protected Attribute parse0(DirectClassFile directClassFile, int n, String string, int n2, int n3, ParseObserver parseObserver) {
        switch (n) {
            case 0: {
                if (string == "Deprecated") {
                    return this.deprecated(directClassFile, n2, n3, parseObserver);
                }
                if (string == "EnclosingMethod") {
                    return this.enclosingMethod(directClassFile, n2, n3, parseObserver);
                }
                if (string == "InnerClasses") {
                    return this.innerClasses(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeInvisibleAnnotations") {
                    return this.runtimeInvisibleAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeVisibleAnnotations") {
                    return this.runtimeVisibleAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Synthetic") {
                    return this.synthetic(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Signature") {
                    return this.signature(directClassFile, n2, n3, parseObserver);
                }
                if (string != "SourceFile") break;
                return this.sourceFile(directClassFile, n2, n3, parseObserver);
            }
            case 1: {
                if (string == "ConstantValue") {
                    return this.constantValue(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Deprecated") {
                    return this.deprecated(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeInvisibleAnnotations") {
                    return this.runtimeInvisibleAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeVisibleAnnotations") {
                    return this.runtimeVisibleAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Signature") {
                    return this.signature(directClassFile, n2, n3, parseObserver);
                }
                if (string != "Synthetic") break;
                return this.synthetic(directClassFile, n2, n3, parseObserver);
            }
            case 2: {
                if (string == "AnnotationDefault") {
                    return this.annotationDefault(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Code") {
                    return this.code(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Deprecated") {
                    return this.deprecated(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Exceptions") {
                    return this.exceptions(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeInvisibleAnnotations") {
                    return this.runtimeInvisibleAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeVisibleAnnotations") {
                    return this.runtimeVisibleAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeInvisibleParameterAnnotations") {
                    return this.runtimeInvisibleParameterAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "RuntimeVisibleParameterAnnotations") {
                    return this.runtimeVisibleParameterAnnotations(directClassFile, n2, n3, parseObserver);
                }
                if (string == "Signature") {
                    return this.signature(directClassFile, n2, n3, parseObserver);
                }
                if (string != "Synthetic") break;
                return this.synthetic(directClassFile, n2, n3, parseObserver);
            }
            case 3: {
                if (string == "LineNumberTable") {
                    return this.lineNumberTable(directClassFile, n2, n3, parseObserver);
                }
                if (string == "LocalVariableTable") {
                    return this.localVariableTable(directClassFile, n2, n3, parseObserver);
                }
                if (string != "LocalVariableTypeTable") break;
                return this.localVariableTypeTable(directClassFile, n2, n3, parseObserver);
            }
        }
        return super.parse0(directClassFile, n, string, n2, n3, parseObserver);
    }

    private Attribute annotationDefault(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser annotationParser = new AnnotationParser(directClassFile, n, n2, parseObserver);
        Constant constant = annotationParser.parseValueAttribute();
        return new AttAnnotationDefault(constant, n2);
    }

    private Attribute code(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        int n3;
        int n4;
        ByteCatchList byteCatchList;
        if (n2 < 12) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray byteArray = directClassFile.getBytes();
        ConstantPool constantPool = directClassFile.getConstantPool();
        int n5 = byteArray.getUnsignedShort(n);
        int n6 = byteArray.getUnsignedShort(n + 2);
        int n7 = byteArray.getInt(n + 4);
        int n8 = n;
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "max_stack: " + Hex.u2(n5));
            parseObserver.parsed(byteArray, n + 2, 2, "max_locals: " + Hex.u2(n6));
            parseObserver.parsed(byteArray, n + 4, 4, "code_length: " + Hex.u4(n7));
        }
        n += 8;
        if ((n2 -= 8) < n7 + 4) {
            return StdAttributeFactory.throwTruncated();
        }
        int n9 = n;
        n += n7;
        n2 -= n7;
        BytecodeArray bytecodeArray = new BytecodeArray(byteArray.slice(n9, n9 + n7), constantPool);
        if (parseObserver != null) {
            bytecodeArray.forEach(new CodeObserver(bytecodeArray.getBytes(), parseObserver));
        }
        ByteCatchList byteCatchList2 = byteCatchList = (n4 = byteArray.getUnsignedShort(n)) == 0 ? ByteCatchList.EMPTY : new ByteCatchList(n4);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "exception_table_length: " + Hex.u2(n4));
        }
        n += 2;
        if ((n2 -= 2) < n4 * 8 + 2) {
            return StdAttributeFactory.throwTruncated();
        }
        for (int i = 0; i < n4; ++i) {
            if (parseObserver != null) {
                parseObserver.changeIndent(1);
            }
            int n10 = byteArray.getUnsignedShort(n);
            n3 = byteArray.getUnsignedShort(n + 2);
            int n11 = byteArray.getUnsignedShort(n + 4);
            int n12 = byteArray.getUnsignedShort(n + 6);
            CstType cstType = (CstType)constantPool.get0Ok(n12);
            byteCatchList.set(i, n10, n3, n11, cstType);
            if (parseObserver != null) {
                parseObserver.parsed(byteArray, n, 8, Hex.u2(n10) + ".." + Hex.u2(n3) + " -> " + Hex.u2(n11) + " " + (cstType == null ? "<any>" : cstType.toHuman()));
            }
            n += 8;
            n2 -= 8;
            if (parseObserver == null) continue;
            parseObserver.changeIndent(-1);
        }
        byteCatchList.setImmutable();
        AttributeListParser attributeListParser = new AttributeListParser(directClassFile, 3, n, this);
        attributeListParser.setObserver(parseObserver);
        StdAttributeList stdAttributeList = attributeListParser.getList();
        stdAttributeList.setImmutable();
        n3 = attributeListParser.getEndOffset() - n;
        if (n3 != n2) {
            return StdAttributeFactory.throwBadLength(n3 + (n - n8));
        }
        return new AttCode(n5, n6, bytecodeArray, byteCatchList, stdAttributeList);
    }

    private Attribute constantValue(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 != 2) {
            return StdAttributeFactory.throwBadLength(2);
        }
        ByteArray byteArray = directClassFile.getBytes();
        ConstantPool constantPool = directClassFile.getConstantPool();
        int n3 = byteArray.getUnsignedShort(n);
        TypedConstant typedConstant = (TypedConstant)constantPool.get(n3);
        AttConstantValue attConstantValue = new AttConstantValue(typedConstant);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "value: " + typedConstant);
        }
        return attConstantValue;
    }

    private Attribute deprecated(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 != 0) {
            return StdAttributeFactory.throwBadLength(0);
        }
        return new AttDeprecated();
    }

    private Attribute enclosingMethod(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 != 4) {
            StdAttributeFactory.throwBadLength(4);
        }
        ByteArray byteArray = directClassFile.getBytes();
        ConstantPool constantPool = directClassFile.getConstantPool();
        int n3 = byteArray.getUnsignedShort(n);
        CstType cstType = (CstType)constantPool.get(n3);
        n3 = byteArray.getUnsignedShort(n + 2);
        CstNat cstNat = (CstNat)constantPool.get0Ok(n3);
        AttEnclosingMethod attEnclosingMethod = new AttEnclosingMethod(cstType, cstNat);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "class: " + cstType);
            parseObserver.parsed(byteArray, n + 2, 2, "method: " + DirectClassFile.stringOrNone(cstNat));
        }
        return attEnclosingMethod;
    }

    private Attribute exceptions(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray byteArray = directClassFile.getBytes();
        int n3 = byteArray.getUnsignedShort(n);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "number_of_exceptions: " + Hex.u2(n3));
        }
        n += 2;
        if ((n2 -= 2) != n3 * 2) {
            StdAttributeFactory.throwBadLength(n3 * 2 + 2);
        }
        TypeList typeList = directClassFile.makeTypeList(n, n3);
        return new AttExceptions(typeList);
    }

    private Attribute innerClasses(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray byteArray = directClassFile.getBytes();
        ConstantPool constantPool = directClassFile.getConstantPool();
        int n3 = byteArray.getUnsignedShort(n);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "number_of_classes: " + Hex.u2(n3));
        }
        n += 2;
        if ((n2 -= 2) != n3 * 8) {
            StdAttributeFactory.throwBadLength(n3 * 8 + 2);
        }
        InnerClassList innerClassList = new InnerClassList(n3);
        for (int i = 0; i < n3; ++i) {
            int n4 = byteArray.getUnsignedShort(n);
            int n5 = byteArray.getUnsignedShort(n + 2);
            int n6 = byteArray.getUnsignedShort(n + 4);
            int n7 = byteArray.getUnsignedShort(n + 6);
            CstType cstType = (CstType)constantPool.get(n4);
            CstType cstType2 = (CstType)constantPool.get0Ok(n5);
            CstString cstString = (CstString)constantPool.get0Ok(n6);
            innerClassList.set(i, cstType, cstType2, cstString, n7);
            if (parseObserver != null) {
                parseObserver.parsed(byteArray, n, 2, "inner_class: " + DirectClassFile.stringOrNone(cstType));
                parseObserver.parsed(byteArray, n + 2, 2, "  outer_class: " + DirectClassFile.stringOrNone(cstType2));
                parseObserver.parsed(byteArray, n + 4, 2, "  name: " + DirectClassFile.stringOrNone(cstString));
                parseObserver.parsed(byteArray, n + 6, 2, "  access_flags: " + AccessFlags.innerClassString(n7));
            }
            n += 8;
        }
        innerClassList.setImmutable();
        return new AttInnerClasses(innerClassList);
    }

    private Attribute lineNumberTable(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray byteArray = directClassFile.getBytes();
        int n3 = byteArray.getUnsignedShort(n);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "line_number_table_length: " + Hex.u2(n3));
        }
        n += 2;
        if ((n2 -= 2) != n3 * 4) {
            StdAttributeFactory.throwBadLength(n3 * 4 + 2);
        }
        LineNumberList lineNumberList = new LineNumberList(n3);
        for (int i = 0; i < n3; ++i) {
            int n4 = byteArray.getUnsignedShort(n);
            int n5 = byteArray.getUnsignedShort(n + 2);
            lineNumberList.set(i, n4, n5);
            if (parseObserver != null) {
                parseObserver.parsed(byteArray, n, 4, Hex.u2(n4) + " " + n5);
            }
            n += 4;
        }
        lineNumberList.setImmutable();
        return new AttLineNumberTable(lineNumberList);
    }

    private Attribute localVariableTable(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray byteArray = directClassFile.getBytes();
        int n3 = byteArray.getUnsignedShort(n);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "local_variable_table_length: " + Hex.u2(n3));
        }
        LocalVariableList localVariableList = this.parseLocalVariables(byteArray.slice(n + 2, n + n2), directClassFile.getConstantPool(), parseObserver, n3, false);
        return new AttLocalVariableTable(localVariableList);
    }

    private Attribute localVariableTypeTable(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray byteArray = directClassFile.getBytes();
        int n3 = byteArray.getUnsignedShort(n);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "local_variable_type_table_length: " + Hex.u2(n3));
        }
        LocalVariableList localVariableList = this.parseLocalVariables(byteArray.slice(n + 2, n + n2), directClassFile.getConstantPool(), parseObserver, n3, true);
        return new AttLocalVariableTypeTable(localVariableList);
    }

    private LocalVariableList parseLocalVariables(ByteArray byteArray, ConstantPool constantPool, ParseObserver parseObserver, int n, boolean bl) {
        if (byteArray.size() != n * 10) {
            StdAttributeFactory.throwBadLength(n * 10 + 2);
        }
        ByteArray.MyDataInputStream myDataInputStream = byteArray.makeDataInputStream();
        LocalVariableList localVariableList = new LocalVariableList(n);
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = myDataInputStream.readUnsignedShort();
                int n3 = myDataInputStream.readUnsignedShort();
                int n4 = myDataInputStream.readUnsignedShort();
                int n5 = myDataInputStream.readUnsignedShort();
                int n6 = myDataInputStream.readUnsignedShort();
                CstString cstString = (CstString)constantPool.get(n4);
                CstString cstString2 = (CstString)constantPool.get(n5);
                CstString cstString3 = null;
                CstString cstString4 = null;
                if (bl) {
                    cstString4 = cstString2;
                } else {
                    cstString3 = cstString2;
                }
                localVariableList.set(i, n2, n3, cstString, cstString3, cstString4, n6);
                if (parseObserver == null) continue;
                parseObserver.parsed(byteArray, i * 10, 10, Hex.u2(n2) + ".." + Hex.u2(n2 + n3) + " " + Hex.u2(n6) + " " + cstString.toHuman() + " " + cstString2.toHuman());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("shouldn't happen", iOException);
        }
        localVariableList.setImmutable();
        return localVariableList;
    }

    private Attribute runtimeInvisibleAnnotations(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser annotationParser = new AnnotationParser(directClassFile, n, n2, parseObserver);
        Annotations annotations = annotationParser.parseAnnotationAttribute(AnnotationVisibility.BUILD);
        return new AttRuntimeInvisibleAnnotations(annotations, n2);
    }

    private Attribute runtimeVisibleAnnotations(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser annotationParser = new AnnotationParser(directClassFile, n, n2, parseObserver);
        Annotations annotations = annotationParser.parseAnnotationAttribute(AnnotationVisibility.RUNTIME);
        return new AttRuntimeVisibleAnnotations(annotations, n2);
    }

    private Attribute runtimeInvisibleParameterAnnotations(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser annotationParser = new AnnotationParser(directClassFile, n, n2, parseObserver);
        AnnotationsList annotationsList = annotationParser.parseParameterAttribute(AnnotationVisibility.BUILD);
        return new AttRuntimeInvisibleParameterAnnotations(annotationsList, n2);
    }

    private Attribute runtimeVisibleParameterAnnotations(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser annotationParser = new AnnotationParser(directClassFile, n, n2, parseObserver);
        AnnotationsList annotationsList = annotationParser.parseParameterAttribute(AnnotationVisibility.RUNTIME);
        return new AttRuntimeVisibleParameterAnnotations(annotationsList, n2);
    }

    private Attribute signature(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 != 2) {
            StdAttributeFactory.throwBadLength(2);
        }
        ByteArray byteArray = directClassFile.getBytes();
        ConstantPool constantPool = directClassFile.getConstantPool();
        int n3 = byteArray.getUnsignedShort(n);
        CstString cstString = (CstString)constantPool.get(n3);
        AttSignature attSignature = new AttSignature(cstString);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "signature: " + cstString);
        }
        return attSignature;
    }

    private Attribute sourceFile(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 != 2) {
            StdAttributeFactory.throwBadLength(2);
        }
        ByteArray byteArray = directClassFile.getBytes();
        ConstantPool constantPool = directClassFile.getConstantPool();
        int n3 = byteArray.getUnsignedShort(n);
        CstString cstString = (CstString)constantPool.get(n3);
        AttSourceFile attSourceFile = new AttSourceFile(cstString);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n, 2, "source: " + cstString);
        }
        return attSourceFile;
    }

    private Attribute synthetic(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (n2 != 0) {
            return StdAttributeFactory.throwBadLength(0);
        }
        return new AttSynthetic();
    }

    private static Attribute throwSeverelyTruncated() {
        throw new ParseException("severely truncated attribute");
    }

    private static Attribute throwTruncated() {
        throw new ParseException("truncated attribute");
    }

    private static Attribute throwBadLength(int n) {
        throw new ParseException("bad attribute length; expected length " + Hex.u4(n));
    }
}

