# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dbt_coverage']

package_data = \
{'': ['*']}

install_requires = \
['typer>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['dbt-coverage = dbt_coverage.__init__:app']}

setup_kwargs = {
    'name': 'dbt-coverage',
    'version': '0.1.8',
    'description': 'One-stop-shop for docs and test coverage of dbt projects',
    'long_description': '# dbt-coverage\n\n<a href="https://pypi.org/project/dbt-coverage/"><img alt="PyPI" src="https://img.shields.io/pypi/v/dbt-coverage"></a>\n<a href="https://pepy.tech/project/dbt-coverage"><img alt="Downloads" src="https://pepy.tech/badge/dbt-coverage"></a>\n![GitHub last commit](https://img.shields.io/github/last-commit/slidoapp/dbt-coverage)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/dbt-coverage)\n![PyPI - Format](https://img.shields.io/pypi/format/dbt-coverage)\n<a href="https://github.com/slidoapp/dbt-coverage/blob/main/LICENSE.md"><img alt="License: MIT" src="https://img.shields.io/github/license/slidoapp/dbt-coverage"></a>\n[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fslidoapp%2Fdbt-coverage.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%2Fslidoapp%2Fdbt-coverage?ref=badge_shield)\n\n\n_One-stop-shop for docs and test coverage of [`dbt`](https://github.com/dbt-labs/dbt) projects._\n\n## Why do I need something like this?\n\n_**[`dbt-coverage`](https://github.com/slidoapp/dbt-coverage) is to [`dbt`](https://github.com/dbt-labs/dbt) what [`coverage.py`](https://github.com/nedbat/coveragepy) and [`interrogate`](https://interrogate.readthedocs.io/en/latest/) are to Python.**_\n\nIt is a single CLI tool which checks your `dbt` project for missing documentation and tests.\n\nKeeping documentation and tests close to the actual SQL code that generates the final model is one of the best design choices of `dbt`. It ensures documentation is actually useful and tests are actually used. But how do you make adding those a habit in your [`dbt`](https://github.com/dbt-labs/dbt) project?\n\nThat is exactly where `dbt-coverage` comes in. It will\n\n- Give you a better sense of the level of documentation and test coverage in your project;\n- Help your CI/CD pipeline make sure new changes include documentation and tests;\n- Let you quickly assess the documentation and tests of a new `dbt` project you get your hands on.\n\nStill not convinced? Here are some more features:\n\n- ✨ **zero-config**: just install it and run it, there is nothing to set up\n- 🏁 **minimal dependences**: the only dependencies are [`click`](https://click.palletsprojects.com/en/8.0.x/) (already installed with [`dbt`](https://github.com/dbt-labs/dbt)) and [`typer`](https://typer.tiangolo.com/tutorial/)\n- 📦 **very small**: at ~480 [SLOC](https://en.wikipedia.org/wiki/Source_lines_of_code), you can easily validate it works as advertised\n\n\n## Demo\nThe package was presented during [Coalesce](https://coalesce.getdbt.com/),\nthe annual dbt conference, as a part of the talk\n[_From 100 spreadsheets to 100 data analysts: the story of dbt at Slido_](https://www.getdbt.com/coalesce-2021/from-spreadsheets-to-data-analysts-the-story-of-dbt-at-slido/).\nWatch a demo in the video below.\n\n[![Demo video](assets/demo.png)](https://youtu.be/YA0yqYSs9BQ?t=936)\n\n## Installation\n\n```\npip install dbt-coverage\n```\n\n## Usage\n\n`dbt-coverage` comes with two basic commands: `compute` and `compare`. The\ndocumentation for the individual commands can be shown by using the `--help`\noption.\n\n### Compute\n\nCompute coverage from `target/catalog.json` and `target/manifest.json` files\nfound in a dbt project, e.g.\n[jaffle_shop](https://github.com/dbt-labs/jaffle_shop). \n\nTo choose between documentation and test coverage, pass `doc` or `test` as the CLI argument.\n\n```console\n$ cd jaffle_shop\n$ dbt run  # Materialize models\n$ dbt docs generate  # Generate catalog.json and manifest.json\n$ dbt-coverage compute doc --cov-report coverage-doc.json  # Compute doc coverage, print it and write it to coverage-doc.json file\n\nCoverage report\n=====================================================================\njaffle_shop.customers                                  6/7      85.7%\njaffle_shop.orders                                     9/9     100.0%\njaffle_shop.raw_customers                              0/3       0.0%\njaffle_shop.raw_orders                                 0/4       0.0%\njaffle_shop.raw_payments                               0/4       0.0%\njaffle_shop.stg_customers                              0/3       0.0%\njaffle_shop.stg_orders                                 0/4       0.0%\njaffle_shop.stg_payments                               0/4       0.0%\n=====================================================================\nTotal                                                 15/38     39.5%\n\n$ dbt-coverage compute test --cov-report coverage-test.json  # Compute test coverage, print it and write it to coverage-test.json file\n\nCoverage report\n=====================================================================\njaffle_shop.customers                                  1/7      14.3%\njaffle_shop.orders                                     8/9      88.9%\njaffle_shop.raw_customers                              0/3       0.0%\njaffle_shop.raw_orders                                 0/4       0.0%\njaffle_shop.raw_payments                               0/4       0.0%\njaffle_shop.stg_customers                              1/3      33.3%\njaffle_shop.stg_orders                                 2/4      50.0%\njaffle_shop.stg_payments                               2/4      50.0%\n=====================================================================\nTotal                                                 14/38     36.8%\n```\n\n### Compare\n\nCompare two `coverage.json` files generated by the `compute` command. This is\nuseful to ensure that the coverage does not drop while making changes to the\nproject.\n\n```console\n$ dbt-coverage compare coverage-after.json coverage-before.json\n\n# Coverage delta summary\n              before     after            +/-\n=============================================\nCoverage      39.47%    38.46%         -1.01%\n=============================================\nTables             8         8          +0/+0\nColumns           38        39          +1/+0\n=============================================\nHits              15        15          +0/+0\nMisses            23        24          +1/+0\n=============================================\n\n# New misses\n=========================================================================\nCatalog                         15/38   (39.47%)  ->    15/39   (38.46%) \n=========================================================================\n- jaffle_shop.customers          6/7    (85.71%)  ->     6/8    (75.00%) \n-- new_col                       -/-       (-)    ->     0/1     (0.00%) \n=========================================================================\n```\n\n### Combined use-case\n\n```console\n$ cd my-dbt-project\n\n$ dbt run  # Materialize models\n$ dbt docs generate  # Generate catalog.json and manifest.json\n$ dbt-coverage compute doc --cov-report before.json --cov-fail-under 0.5  # Fail if coverage is lower than 50%\n\n# Make changes to the dbt project, e.g. add some columns to the DWH, document some columns, etc.\n\n$ dbt run  # Materialize the changed models\n$ dbt docs generate  # Generate catalog.json and manifest.json\n$ dbt-coverage compute doc --cov-report after.json --cov-fail-compare before.json  # Fail if the current coverage is lower than coverage in before.json\n$ dbt-coverage compare after.json before.json  # Generate a detailed coverage delta report\n```\n\n## Related packages\n\n- https://github.com/mikaelene/dbt-test-coverage\n- [interrogate](https://interrogate.readthedocs.io/en/latest/) (docs coverage for Python)\n- [coverage.py](https://github.com/nedbat/coveragepy) (execution coverage for Python)\n\n## License\n\nLicensed under the MIT license (see [LICENSE.md](LICENSE.md) file for more\ndetails).\n\n[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fslidoapp%2Fdbt-coverage.svg?type=large)](https://app.fossa.com/projects/git%2Bgithub.com%2Fslidoapp%2Fdbt-coverage?ref=badge_large)\n',
    'author': 'Andrej Švec',
    'author_email': 'asvec@slido.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
