# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from __future__ import annotations

from typing import MutableMapping, MutableSequence

import proto  # type: ignore

from google.protobuf import timestamp_pb2  # type: ignore


__protobuf__ = proto.module(
    package='google.events.cloud.beyondcorp.appconnections.v1',
    manifest={
        'AppConnection',
        'AppConnectionEventData',
    },
)


class AppConnection(proto.Message):
    r"""A BeyondCorp AppConnection resource represents a BeyondCorp
    protected AppConnection to a remote application. It creates all
    the necessary GCP components needed for creating a BeyondCorp
    protected AppConnection. Multiple connectors can be authorised
    for a single AppConnection.

    Attributes:
        name (str):
            Required. Unique resource name of the
            AppConnection. The name is ignored when creating
            a AppConnection.
        create_time (google.protobuf.timestamp_pb2.Timestamp):
            Output only. Timestamp when the resource was
            created.
        update_time (google.protobuf.timestamp_pb2.Timestamp):
            Output only. Timestamp when the resource was
            last modified.
        labels (MutableMapping[str, str]):
            Optional. Resource labels to represent user
            provided metadata.
        display_name (str):
            Optional. An arbitrary user-provided name for
            the AppConnection. Cannot exceed 64 characters.
        uid (str):
            Output only. A unique identifier for the
            instance generated by the system.
        type_ (google.events.cloud.beyondcorp.appconnections_v1.types.AppConnection.Type):
            Required. The type of network connectivity
            used by the AppConnection.
        application_endpoint (google.events.cloud.beyondcorp.appconnections_v1.types.AppConnection.ApplicationEndpoint):
            Required. Address of the remote application
            endpoint for the BeyondCorp AppConnection.
        connectors (MutableSequence[str]):
            Optional. List of
            [google.cloud.beyondcorp.v1main.Connector.name] that are
            authorised to be associated with this AppConnection.
        state (google.events.cloud.beyondcorp.appconnections_v1.types.AppConnection.State):
            Output only. The current state of the
            AppConnection.
        gateway (google.events.cloud.beyondcorp.appconnections_v1.types.AppConnection.Gateway):
            Optional. Gateway used by the AppConnection.
    """
    class Type(proto.Enum):
        r"""Enum containing list of all possible network connectivity
        options supported by BeyondCorp AppConnection.

        Values:
            TYPE_UNSPECIFIED (0):
                Default value. This value is unused.
            TCP_PROXY (1):
                TCP Proxy based BeyondCorp AppConnection. API
                will default to this if unset.
        """
        TYPE_UNSPECIFIED = 0
        TCP_PROXY = 1

    class State(proto.Enum):
        r"""Represents the different states of a AppConnection.

        Values:
            STATE_UNSPECIFIED (0):
                Default value. This value is unused.
            CREATING (1):
                AppConnection is being created.
            CREATED (2):
                AppConnection has been created.
            UPDATING (3):
                AppConnection's configuration is being
                updated.
            DELETING (4):
                AppConnection is being deleted.
            DOWN (5):
                AppConnection is down and may be restored in
                the future. This happens when CCFE sends
                ProjectState = OFF.
        """
        STATE_UNSPECIFIED = 0
        CREATING = 1
        CREATED = 2
        UPDATING = 3
        DELETING = 4
        DOWN = 5

    class ApplicationEndpoint(proto.Message):
        r"""ApplicationEndpoint represents a remote application endpoint.

        Attributes:
            host (str):
                Required. Hostname or IP address of the
                remote application endpoint.
            port (int):
                Required. Port of the remote application
                endpoint.
        """

        host: str = proto.Field(
            proto.STRING,
            number=1,
        )
        port: int = proto.Field(
            proto.INT32,
            number=2,
        )

    class Gateway(proto.Message):
        r"""Gateway represents a user facing component that serves as an
        entrance to enable connectivity.

        Attributes:
            type_ (google.events.cloud.beyondcorp.appconnections_v1.types.AppConnection.Gateway.Type):
                Required. The type of hosting used by the
                gateway.
            uri (str):
                Output only. Server-defined URI for this
                resource.
            ingress_port (int):
                Output only. Ingress port reserved on the
                gateways for this AppConnection, if not
                specified or zero, the default port is 19443.
            app_gateway (str):
                Required. AppGateway name in following format:
                ``projects/{project_id}/locations/{location_id}/appgateways/{gateway_id}``
            l7psc (str):
                Output only. L7 private service connection
                for this resource.
        """
        class Type(proto.Enum):
            r"""Enum listing possible gateway hosting options.

            Values:
                TYPE_UNSPECIFIED (0):
                    Default value. This value is unused.
                GCP_REGIONAL_MIG (1):
                    Gateway hosted in a GCP regional managed
                    instance group.
            """
            TYPE_UNSPECIFIED = 0
            GCP_REGIONAL_MIG = 1

        type_: 'AppConnection.Gateway.Type' = proto.Field(
            proto.ENUM,
            number=2,
            enum='AppConnection.Gateway.Type',
        )
        uri: str = proto.Field(
            proto.STRING,
            number=3,
        )
        ingress_port: int = proto.Field(
            proto.INT32,
            number=4,
        )
        app_gateway: str = proto.Field(
            proto.STRING,
            number=5,
        )
        l7psc: str = proto.Field(
            proto.STRING,
            number=6,
        )

    name: str = proto.Field(
        proto.STRING,
        number=1,
    )
    create_time: timestamp_pb2.Timestamp = proto.Field(
        proto.MESSAGE,
        number=2,
        message=timestamp_pb2.Timestamp,
    )
    update_time: timestamp_pb2.Timestamp = proto.Field(
        proto.MESSAGE,
        number=3,
        message=timestamp_pb2.Timestamp,
    )
    labels: MutableMapping[str, str] = proto.MapField(
        proto.STRING,
        proto.STRING,
        number=4,
    )
    display_name: str = proto.Field(
        proto.STRING,
        number=5,
    )
    uid: str = proto.Field(
        proto.STRING,
        number=6,
    )
    type_: Type = proto.Field(
        proto.ENUM,
        number=7,
        enum=Type,
    )
    application_endpoint: ApplicationEndpoint = proto.Field(
        proto.MESSAGE,
        number=8,
        message=ApplicationEndpoint,
    )
    connectors: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=9,
    )
    state: State = proto.Field(
        proto.ENUM,
        number=10,
        enum=State,
    )
    gateway: Gateway = proto.Field(
        proto.MESSAGE,
        number=11,
        message=Gateway,
    )


class AppConnectionEventData(proto.Message):
    r"""The data within all AppConnection events.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        payload (google.events.cloud.beyondcorp.appconnections_v1.types.AppConnection):
            Optional. The AppConnection event payload.
            Unset for deletion events.

            This field is a member of `oneof`_ ``_payload``.
    """

    payload: 'AppConnection' = proto.Field(
        proto.MESSAGE,
        number=1,
        optional=True,
        message='AppConnection',
    )


__all__ = tuple(sorted(__protobuf__.manifest))
