# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/config/change/network/types.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


@dataclass(eq=False, repr=False)
class NetworkChange(betterproto.Message):
    """
    NetworkChange specifies the configuration for a network change A network
    change is a configuration change that spans multiple devices. The change
    contains a list of per-device changes to be applied to the network.
    """

    # 'id' is the unique identifier of the change This field should be set prior
    # to persisting the object.
    id: str = betterproto.string_field(1)
    # 'index' is a monotonically increasing, globally unique index of the change
    # The index is provided by the store, is static and unique for each unique
    # change identifier, and should not be modified by client code.
    index: int = betterproto.uint64_field(2)
    # 'revision' is the change revision number The revision number is provided by
    # the store and should not be modified by client code. Each unique state of
    # the change will be assigned a unique revision number which can be used for
    # optimistic concurrency control when updating or deleting the change state.
    revision: int = betterproto.uint64_field(3)
    # 'status' is the current lifecycle status of the change
    status: "__change__.Status" = betterproto.message_field(4)
    # 'created' is the time at which the change was created
    created: datetime = betterproto.message_field(5)
    # 'updated' is the time at which the change was last updated
    updated: datetime = betterproto.message_field(6)
    # 'changes' is a set of changes to apply to devices The list of changes
    # should contain only a single change per device/version pair.
    changes: List["_device__.Change"] = betterproto.message_field(7)
    # 'refs' is a set of references to stored device changes
    refs: List["DeviceChangeRef"] = betterproto.message_field(8)
    # 'deleted' is a flag indicating whether this change is being deleted by a
    # snapshot
    deleted: bool = betterproto.bool_field(9)
    # 'dependency' is a reference to the network change on which this change is
    # dependent
    dependency: "NetworkChangeRef" = betterproto.message_field(10)
    # 'dependents' is a list of references to network changes that depend on this
    # change
    dependents: List["NetworkChangeRef"] = betterproto.message_field(11)


@dataclass(eq=False, repr=False)
class NetworkChangeRef(betterproto.Message):
    """NetworkChangeRef is a reference to a network change"""

    none: "betterproto_lib_google_protobuf.Empty" = betterproto.message_field(
        1, group="id"
    )
    network_change_id: str = betterproto.string_field(2, group="id")


@dataclass(eq=False, repr=False)
class DeviceChangeRef(betterproto.Message):
    """DeviceChangeRef is a reference to a device change"""

    # 'device_change_id' is the unique identifier of the device change
    device_change_id: str = betterproto.string_field(1)


from .. import device as _device__
from ... import change as __change__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
