/*
 * Decompiled with CFR 0.152.
 */
package injector;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import injector.BusyIndicatorWindow;
import injector.ImageStreamer;
import injector.InjectorSetupWindow;
import injector.SortedCoordsList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.micromanager.Studio;
import org.micromanager.data.Coords;
import org.micromanager.data.Datastore;
import org.micromanager.data.DatastoreFrozenException;
import org.micromanager.data.DatastoreRewriteException;
import org.micromanager.data.Image;
import org.micromanager.data.Metadata;

public class TiffParser {
    private BusyIndicatorWindow window = new BusyIndicatorWindow(null, true);
    private final InjectorSetupWindow setup_window;
    private final Studio app;
    private File tiff_file;
    private Datastore store;
    private SortedCoordsList coords_list;
    private long frameLengthMs;
    private Coords.CoordsBuilder c_builder;
    private Metadata.MetadataBuilder m_builder;

    public TiffParser(Studio studio, long frameLengthMs, InjectorSetupWindow setup_window) {
        this.frameLengthMs = frameLengthMs;
        this.app = studio;
        this.setup_window = setup_window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadGeneralTiff(File file) throws FileNotFoundException, IOException {
        ImagePlus win;
        this.window.setProgress(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TiffParser.this.window.setVisible(true);
            }
        });
        this.app.logs().logMessage("Trying to open general tiff.");
        try (FileInputStream input_stream = new FileInputStream(file);){
            Opener o = new Opener();
            win = o.openTiff((InputStream)input_stream, "InjectorStack");
        }
        ImageStack stack = win.getImageStack();
        this.m_builder = this.app.data().getMetadataBuilder();
        this.m_builder.imageNumber(Long.valueOf(0L)).camera("ImageInjector").exposureMs(Double.valueOf(1.0)).xPositionUm(Double.valueOf(0.0)).yPositionUm(Double.valueOf(0.0)).zPositionUm(Double.valueOf(0.0)).positionName("Injection");
        int n_channels = win.getNChannels();
        int width = stack.getWidth();
        int height = stack.getHeight();
        if (!(stack.getPixels(win.getSlice()) instanceof short[])) {
            throw new ArrayStoreException("Wrong image bit depth.");
        }
        int bytesPerPixel = 2;
        Coords intended_coords = this.app.data().coordsBuilder().c(n_channels).t(stack.getSize() / n_channels).build();
        System.out.println(String.format("LOADING %d CHANNELS", n_channels));
        this.store.setSummaryMetadata(this.app.data().summaryMetadataBuilder().intendedDimensions(intended_coords).build());
        this.window.setMaximum(stack.getSize());
        this.c_builder.time(0);
        for (int i = 1; i <= stack.getSize() / n_channels; ++i) {
            for (int channel = 0; channel <= n_channels - 1; ++channel) {
                this.c_builder.channel(channel);
                Coords coords = this.c_builder.build();
                Metadata metadata = this.m_builder.build();
                Image ram_image = this.app.data().createImage(stack.getPixels(i * n_channels - channel), width, height, bytesPerPixel, 1, coords, metadata);
                try {
                    this.store.putImage(ram_image);
                }
                catch (DatastoreFrozenException ex) {
                    Logger.getLogger(ImageStreamer.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (DatastoreRewriteException ex) {
                    Logger.getLogger(ImageStreamer.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(ImageStreamer.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.coords_list.add(coords);
            }
            this.c_builder.time(i);
            this.m_builder.imageNumber(Long.valueOf(i)).elapsedTimeMs(Double.valueOf((double)i * (double)this.frameLengthMs));
            if (i % 100 == 0) {
                this.app.logs().logDebugMessage(String.format("Loaded %d images from general tiff stack.", i));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TiffParser.this.window.increment();
                }
            });
        }
        if (this.setup_window != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TiffParser.this.setup_window.setTiffLoaded(true);
                }
            });
        }
    }

    public final void loadScrubbedData(File file) {
        this.app.logs().logDebugMessage(String.format("Parsing .tiff file: %s", file.getAbsolutePath()));
        this.store = this.app.data().createRAMDatastore();
        this.coords_list = new SortedCoordsList();
        this.c_builder = this.app.data().getCoordsBuilder();
        this.c_builder.channel(0).stagePosition(0).time(0).z(0);
        Object disk_store = null;
        try {
            this.loadGeneralTiff(file);
        }
        catch (Exception ex2) {
            Logger.getLogger(ImageStreamer.class.getName()).log(Level.SEVERE, null, ex2);
            this.app.logs().showError("Loading of .tiff file failed.");
            this.store = null;
            this.coords_list = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TiffParser.this.window.dispose();
                    TiffParser.this.setup_window.setTiffLoaded(false);
                }
            });
            return;
        }
        this.tiff_file = file;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TiffParser.this.window.dispose();
            }
        });
    }

    public Datastore getDatastore() {
        return this.store;
    }

    public SortedCoordsList getCoordsList() {
        return this.coords_list;
    }
}

