/*
 * Decompiled with CFR 0.152.
 */
package injector;

import injector.InjectorConfigurator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.micromanager.PropertyMap;

public class InjectorSetupWindow
extends JDialog {
    PropertyMap.PropertyMapBuilder builder;
    InjectorConfigurator configurator;
    File tiff_file;
    private JButton OK_button;
    private JButton b_clear;
    private JButton choose_file_button;
    private JTextField frames_per_second;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel l_is_tiff_loaded;
    private JLabel label_filepath;

    public InjectorSetupWindow(Frame parent, boolean modal, InjectorConfigurator configurator) {
        super(parent, modal);
        this.configurator = configurator;
        this.builder = configurator.getSettings().copy();
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.frames_per_second = new JTextField();
        this.OK_button = new JButton();
        this.choose_file_button = new JButton();
        this.jLabel2 = new JLabel();
        this.label_filepath = new JLabel();
        this.l_is_tiff_loaded = new JLabel();
        this.b_clear = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Frames per second:");
        this.frames_per_second.setHorizontalAlignment(11);
        this.frames_per_second.setText("5");
        this.frames_per_second.setPreferredSize(new Dimension(30, 20));
        this.OK_button.setText("OK");
        this.OK_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InjectorSetupWindow.this.OK_buttonActionPerformed(evt);
            }
        });
        this.choose_file_button.setText("Choose file...");
        this.choose_file_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InjectorSetupWindow.this.choose_file_buttonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Current file:");
        this.label_filepath.setText("<none>");
        this.label_filepath.setMaximumSize(new Dimension(100, 14));
        this.l_is_tiff_loaded.setForeground(new Color(153, 0, 51));
        this.l_is_tiff_loaded.setText("Tiff not loaded");
        this.b_clear.setText("Clear");
        this.b_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InjectorSetupWindow.this.b_clearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.frames_per_second, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.choose_file_button).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label_filepath, -2, 87, -2))).addGap(0, 10, Short.MAX_VALUE))).addContainerGap(20, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.l_is_tiff_loaded).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.b_clear).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(72, 72, 72).addComponent(this.OK_button).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.frames_per_second, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.choose_file_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.label_filepath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.b_clear).addComponent(this.l_is_tiff_loaded)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE).addComponent(this.OK_button).addContainerGap()));
        this.pack();
    }

    private void OK_buttonActionPerformed(ActionEvent evt) {
        long FPS;
        try {
            FPS = Long.parseLong(this.frames_per_second.getText());
        }
        catch (NumberFormatException ex) {
            this.configurator.context.app.logs().showError("Wrong input format.");
            return;
        }
        this.configurator.context.streamer.setFPS(FPS);
        this.configurator.setPropertyMap(this.builder.build());
        this.configurator.context.streamer.setFile(this.tiff_file, this);
        this.setVisible(false);
    }

    private void choose_file_buttonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this.choose_file_button);
        if (returnVal != 0) {
            return;
        }
        this.tiff_file = fc.getSelectedFile();
        this.label_filepath.setText(this.tiff_file.getName());
    }

    private void b_clearActionPerformed(ActionEvent evt) {
        this.setTiffLoaded(false);
        this.label_filepath.setText("<none>");
        this.tiff_file = null;
        this.configurator.context.streamer.setFile(null, null);
    }

    public void setTiffLoaded(boolean isLoaded) {
        if (isLoaded) {
            this.l_is_tiff_loaded.setText("Tiff loaded");
            this.l_is_tiff_loaded.setForeground(Color.decode("0x006600"));
        } else {
            this.l_is_tiff_loaded.setText("Tiff not loaded");
            this.l_is_tiff_loaded.setForeground(Color.decode("0x990033"));
        }
    }
}

