/*
 * Decompiled with CFR 0.152.
 */
package injector;

import injector.InjectorSetupWindow;
import injector.SortedCoordsList;
import injector.TiffParser;
import java.io.File;
import org.micromanager.Studio;
import org.micromanager.data.Coords;
import org.micromanager.data.Datastore;
import org.micromanager.data.Image;

public class ImageStreamer {
    private final Studio app;
    private File tiff_file;
    private Datastore store;
    private SortedCoordsList coords_list;
    private int img_count = 0;
    private int channel = 0;
    private long lastFrameTimeMs = 0L;
    private long frameLengthMs = 100L;
    private long now;
    private int NumberOfChannels;
    private Image new_image;
    private int timePoint;

    public ImageStreamer(Studio studio) {
        this.app = studio;
        this.setFile(null, null);
        this.setFPS(5L);
    }

    public final void setFile(final File file, InjectorSetupWindow setup_window) {
        String new_path = "";
        String old_path = "";
        try {
            new_path = file.getAbsolutePath();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            old_path = this.tiff_file.getAbsolutePath();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (new_path.equalsIgnoreCase("")) {
            this.tiff_file = null;
            this.store = null;
            this.coords_list = null;
            System.gc();
            return;
        }
        if (old_path.equals(new_path)) {
            return;
        }
        this.tiff_file = null;
        this.store = null;
        this.coords_list = null;
        System.gc();
        final TiffParser parser = new TiffParser(this.app, this.frameLengthMs, setup_window);
        new Thread(new Runnable(){

            @Override
            public void run() {
                parser.loadScrubbedData(file);
                ImageStreamer.this.store = parser.getDatastore();
                ImageStreamer.this.coords_list = parser.getCoordsList();
                ImageStreamer.this.tiff_file = file;
                ImageStreamer.this.NumberOfChannels = ImageStreamer.this.getNoOfChannels();
            }
        }).start();
    }

    public final long getFPS() {
        return 1000L / this.frameLengthMs;
    }

    public final void setFPS(long framesPerSecond) {
        this.frameLengthMs = 1000L / framesPerSecond;
        this.app.logs().logMessage(String.format("Set ImageFactory frameLengthMs to %d from %d FPS. (%d leftover)", this.frameLengthMs, framesPerSecond, 1000L % framesPerSecond));
    }

    public int getNoOfImages() {
        return this.store.getNumImages();
    }

    public int getNoOfChannels() {
        return this.store.getSummaryMetadata().getIntendedDimensions().getChannel();
    }

    public Image getNextImage(Coords coords) throws InterruptedException {
        if (this.store == null) {
            return null;
        }
        this.channel = coords.getChannel();
        if (this.channel == 0) {
            this.now = System.currentTimeMillis();
            int jumpBy = Math.round((this.now - this.lastFrameTimeMs) / this.frameLengthMs);
            this.timePoint += jumpBy;
            System.out.println(String.format("Attempting time jump by %d", jumpBy));
            this.lastFrameTimeMs = System.currentTimeMillis();
        }
        if (this.timePoint > this.store.getNextIndex("time") - 1) {
            this.timePoint = 0;
        }
        try {
            this.new_image = this.store.getImage(coords.copyBuilder().t(this.timePoint % this.coords_list.size()).build());
            this.new_image = this.new_image.copyAtCoords(coords);
            return this.new_image;
        }
        catch (Exception e) {
            System.out.println("Image IO error");
            throw new InterruptedException();
        }
    }
}

