/*
 * Decompiled with CFR 0.152.
 */
package injector;

import injector.ImageStreamer;
import injector.InjectorConfigurator;
import injector.InjectorContext;
import injector.InjectorFactory;
import org.micromanager.PropertyMap;
import org.micromanager.Studio;
import org.micromanager.data.ProcessorConfigurator;
import org.micromanager.data.ProcessorFactory;
import org.micromanager.data.ProcessorPlugin;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.SciJavaPlugin;

@Plugin(type=ProcessorPlugin.class)
public class ImageInjectorPlugin
implements ProcessorPlugin,
SciJavaPlugin {
    public static final String menuName = "Image Injector";
    private Studio app;
    private ImageStreamer streamer;
    private InjectorContext context;

    public ImageStreamer getImageStreamer() {
        return this.streamer;
    }

    public ProcessorConfigurator createConfigurator(PropertyMap pm) {
        return new InjectorConfigurator(pm, this.context);
    }

    public ProcessorFactory createFactory(PropertyMap pm) {
        return new InjectorFactory(pm, this.context);
    }

    public void setContext(Studio studio) {
        this.app = studio;
        this.streamer = new ImageStreamer(this.app);
        this.context = new InjectorContext(this.app, this, this.streamer);
    }

    public String getName() {
        return menuName;
    }

    public String getHelpText() {
        return "Replaces images from camera in processing pipeline with ones from chosen .tiff stack.";
    }

    public String getVersion() {
        return "0.1";
    }

    public String getCopyright() {
        return "MIT License, 2017 Marcel Stefko, LEB EPFL";
    }
}

