import setuptools
import os

if __name__ == '__main__':
    # description
    with open(os.path.join(os.path.dirname(os.path.realpath(__file__)), "README.md"), "r") as fh:
        long_description = fh.read()

    # requirements
    with open(os.path.join(os.path.dirname(os.path.realpath(__file__)), "requirements.txt"), "r") as f:
        requirements = f.read().splitlines()

    setuptools.setup(
        name="Confluence-Task-Crawler",
        version="0.0.1",
        author="Bernhard Buhl",
        author_email="buhl@buhl-consulting.com.cy",
        description="Task Crawler and Reporter with Dashboard for Atlassian Confluence On-Prem Installations",
        long_description=long_description,
        long_description_content_type="text/markdown",
        url="https://www.buhl-consulting.com.cy",
        packages=setuptools.find_packages(),
        data_files=[],
        package_data={},
        install_requires=requirements,
        classifiers=[
            "Programming Language :: Python :: 3",
            "License :: OSI Approved :: MIT License",
            "Operating System :: OS Independent",
        ],
        include_package_data=True,
        python_requires='>=3.6',
    )
