/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import cdjd.com.dremio.exec.client.ServerMethod;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.com.google.common.primitives.Longs;
import cdjd.org.apache.calcite.avatica.AvaticaStatement;
import cdjd.org.apache.calcite.avatica.AvaticaUtils;
import cdjd.org.apache.calcite.avatica.ColumnMetaData;
import cdjd.org.apache.calcite.avatica.Meta;
import cdjd.org.apache.calcite.avatica.MetaImpl;
import cdjd.org.apache.calcite.avatica.MissingResultsException;
import cdjd.org.apache.calcite.avatica.NoSuchStatementException;
import cdjd.org.apache.calcite.avatica.QueryState;
import cdjd.org.apache.calcite.avatica.remote.TypedValue;
import cdjd.org.apache.calcite.util.Util;
import com.dremio.jdbc.impl.DremioColumnMetaDataList;
import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioMeta;
import com.dremio.jdbc.impl.DremioMetaClientImpl;
import com.dremio.jdbc.impl.DremioMetaServerImpl;
import com.dremio.jdbc.impl.SQLExecutionError;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class DremioMetaImpl
extends MetaImpl {
    static final int DECIMAL_DIGITS_REAL = 7;
    static final int DECIMAL_DIGITS_FLOAT = 7;
    static final int DECIMAL_DIGITS_DOUBLE = 15;
    static final int RADIX_DATETIME = 10;
    static final int RADIX_INTERVAL = 10;
    private final DremioConnectionImpl connection;
    private volatile DremioMeta delegate;

    DremioMetaImpl(DremioConnectionImpl connection) {
        super(connection);
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DremioMeta getDelegate() throws SQLException {
        if (this.delegate == null) {
            DremioMetaImpl dremioMetaImpl = this;
            synchronized (dremioMetaImpl) {
                if (this.delegate == null) {
                    List<ServerMethod> requiredMetaMethods = Arrays.asList(ServerMethod.GET_CATALOGS, ServerMethod.GET_SCHEMAS, ServerMethod.GET_TABLES, ServerMethod.GET_COLUMNS);
                    this.delegate = this.connection.getConfig().isServerMetadataDisabled() || !this.connection.getClient().getSupportedMethods().containsAll(requiredMetaMethods) ? new DremioMetaClientImpl(this.connection) : new DremioMetaServerImpl(this.connection);
                }
            }
        }
        return this.delegate;
    }

    static Meta.Signature newSignature(String sql) {
        return new Meta.Signature(new DremioColumnMetaDataList(), sql, Collections.emptyList(), Collections.emptyMap(), null, Meta.StatementType.SELECT);
    }

    protected static ColumnMetaData.StructType fieldMetaData(Class<?> clazz) {
        return MetaImpl.fieldMetaData(clazz);
    }

    @Override
    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        try {
            return this.getDelegate().getTables(catalog, schemaPattern, tableNamePattern, typeList);
        }
        catch (SQLException e) {
            throw new SQLExecutionError(e.getMessage(), e);
        }
    }

    @Override
    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        try {
            return this.getDelegate().getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw new SQLExecutionError(e.getMessage(), e);
        }
    }

    @Override
    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        try {
            return this.getDelegate().getSchemas(catalog, schemaPattern);
        }
        catch (SQLException e) {
            throw new SQLExecutionError(e.getMessage(), e);
        }
    }

    @Override
    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        try {
            return this.getDelegate().getCatalogs();
        }
        catch (SQLException e) {
            throw new SQLExecutionError(e.getMessage(), e);
        }
    }

    @Override
    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, long maxRowCount) {
        Meta.StatementHandle result = super.createStatement(ch);
        result.signature = DremioMetaImpl.newSignature(sql);
        return result;
    }

    @Override
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h2, String sql, long maxRowCount, Meta.PrepareCallback callback) {
        return this.prepareAndExecute(h2, sql, maxRowCount, -1, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h2, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) {
        Meta.Signature signature = DremioMetaImpl.newSignature(sql);
        try {
            Object object = callback.getMonitor();
            synchronized (object) {
                callback.clear();
                callback.assign(signature, null, -1L);
            }
            callback.execute();
            Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create(h2.connectionId, h2.id, false, signature, null);
            return new Meta.ExecuteResult(Collections.singletonList(metaResultSet));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle h2, List<String> sqlCommands) throws NoSuchStatementException {
        final ArrayList updateCounts = new ArrayList();
        Meta.PrepareCallback callback = new Meta.PrepareCallback(){
            private final Object monitor = new Object();
            long updateCount;

            @Override
            public Object getMonitor() {
                return this.monitor;
            }

            @Override
            public void clear() throws SQLException {
            }

            @Override
            public void assign(Meta.Signature signature, Meta.Frame firstFrame, long updateCount) throws SQLException {
                this.updateCount = updateCount;
            }

            @Override
            public void execute() throws SQLException {
                updateCounts.add(this.updateCount);
            }
        };
        for (String sqlCommand : sqlCommands) {
            Util.discard((Object)this.prepareAndExecute(h2, sqlCommand, -1L, -1, callback));
        }
        return new Meta.ExecuteBatchResult(Longs.toArray(updateCounts));
    }

    @Override
    public Meta.ExecuteResult execute(Meta.StatementHandle h2, List<TypedValue> parameterValues, int maxRowsInFirstFrame) throws NoSuchStatementException {
        AvaticaStatement stmt;
        try {
            stmt = this.connection.lookupStatement(h2);
        }
        catch (SQLException e) {
            throw new NoSuchStatementException(h2);
        }
        Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create(h2.connectionId, h2.id, false, stmt.handle.signature, null);
        return new Meta.ExecuteResult(ImmutableList.of(metaResultSet));
    }

    @Override
    public Meta.ExecuteResult execute(Meta.StatementHandle h2, List<TypedValue> parameterValues, long maxRowCount) throws NoSuchStatementException {
        return this.execute(h2, parameterValues, AvaticaUtils.toSaturatedInt(maxRowCount));
    }

    @Override
    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle h2, List<List<TypedValue>> parameterValueLists) throws NoSuchStatementException {
        ArrayList<Long> updateCounts = new ArrayList<Long>();
        for (List<TypedValue> parameterValueList : parameterValueLists) {
            Meta.ExecuteResult executeResult = this.execute(h2, parameterValueList, -1);
            long updateCount = executeResult.resultSets.size() == 1 ? executeResult.resultSets.get((int)0).updateCount : -1L;
            updateCounts.add(updateCount);
        }
        return new Meta.ExecuteBatchResult(Longs.toArray(updateCounts));
    }

    @Override
    public void openConnection(Meta.ConnectionHandle ch, Map<String, String> info) {
        super.openConnection(ch, info);
    }

    @Override
    public void commit(Meta.ConnectionHandle ch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback(Meta.ConnectionHandle ch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Meta.Frame fetch(Meta.StatementHandle h2, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean syncResults(Meta.StatementHandle sh, QueryState state, long offset) throws NoSuchStatementException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeStatement(Meta.StatementHandle h2) {
    }
}

