/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import cdjd.com.dremio.common.util.DremioStringUtils;
import cdjd.org.apache.calcite.avatica.AvaticaStatement;
import cdjd.org.apache.calcite.avatica.Meta;
import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioMeta;
import com.dremio.jdbc.impl.DremioMetaImpl;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DremioMetaClientImpl
implements DremioMeta {
    private static final Logger logger = LoggerFactory.getLogger(DremioMetaClientImpl.class);
    private final DremioConnectionImpl connection;
    private final String identifierQuote;
    private final String searchStringEscape;

    public DremioMetaClientImpl(DremioConnectionImpl connection) throws SQLException {
        this.connection = connection;
        this.identifierQuote = connection.getMetaData().getIdentifierQuoteString();
        this.searchStringEscape = connection.getMetaData().getSearchStringEscape();
    }

    private Meta.MetaResultSet s(String s2) throws SQLException {
        try {
            logger.debug("Running {}", (Object)s2);
            AvaticaStatement statement = this.connection.createStatement();
            return Meta.MetaResultSet.create(this.connection.id, statement.getId(), true, DremioMetaImpl.newSignature(s2), null);
        }
        catch (Exception e) {
            throw new SQLException("Failure while attempting to get DatabaseMetadata.", e);
        }
    }

    @Override
    public Meta.MetaResultSet getCatalogs() throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.CATALOGS ");
        sb.append(" ORDER BY CATALOG_NAME");
        return this.s(sb.toString());
    }

    @Override
    public Meta.MetaResultSet getSchemas(String catalog, Meta.Pat schemaPattern) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select SCHEMA_NAME as TABLE_SCHEM, CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.SCHEMATA WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND CATALOG_NAME = '" + DremioStringUtils.escapeSql(catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND SCHEMA_NAME like '" + DremioStringUtils.escapeSql(schemaPattern.s) + "' escape '" + this.searchStringEscape + "'");
        }
        sb.append(" ORDER BY CATALOG_NAME, SCHEMA_NAME");
        return this.s(sb.toString());
    }

    @Override
    public Meta.MetaResultSet getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("select TABLE_CATALOG as TABLE_CAT, TABLE_SCHEMA as TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, '' as REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' as SELF_REFERENCING_COL_NAME, '' as REF_GENERATION FROM INFORMATION_SCHEMA." + this.identifierQuote + "TABLES" + this.identifierQuote + " WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND TABLE_CATALOG = '" + DremioStringUtils.escapeSql(catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND TABLE_SCHEMA like '" + DremioStringUtils.escapeSql(schemaPattern.s) + "' escape '" + this.searchStringEscape + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append(" AND TABLE_NAME like '" + DremioStringUtils.escapeSql(tableNamePattern.s) + "' escape '" + this.searchStringEscape + "'");
        }
        if (typeList != null && typeList.size() > 0) {
            sb.append(" AND (");
            for (int t = 0; t < typeList.size(); ++t) {
                if (t != 0) {
                    sb.append(" OR ");
                }
                sb.append(" TABLE_TYPE LIKE '" + DremioStringUtils.escapeSql(typeList.get(t)) + "' escape '" + this.searchStringEscape + "' ");
            }
            sb.append(")");
        }
        sb.append(" ORDER BY TABLE_TYPE, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME");
        return this.s(sb.toString());
    }

    @Override
    public Meta.MetaResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  TABLE_CATALOG                 as  TABLE_CAT, \n  TABLE_SCHEMA                  as  TABLE_SCHEM, \n  TABLE_NAME                    as  TABLE_NAME, \n  COLUMN_NAME                   as  COLUMN_NAME, \n  CASE DATA_TYPE \n    WHEN 'ARRAY'                       THEN 2003\n    WHEN 'BIGINT'                      THEN -5\n    WHEN 'BINARY'                      THEN -2\n    WHEN 'BINARY LARGE OBJECT'         THEN 2004\n    WHEN 'BINARY VARYING'              THEN -3\n    WHEN 'BIT'                         THEN -7\n    WHEN 'BOOLEAN'                     THEN 16\n    WHEN 'CHARACTER'                   THEN 1\n    WHEN 'CHARACTER LARGE OBJECT'      THEN 2005\n    WHEN 'CHARACTER VARYING'           THEN 12\n    WHEN 'DATALINK'                    THEN 70\n    WHEN 'DATE'                        THEN 91\n    WHEN 'DECIMAL'                     THEN 3\n    WHEN 'DISTINCT'                    THEN 2001\n    WHEN 'DOUBLE', 'DOUBLE PRECISION'  THEN 8\n    WHEN 'FLOAT'                       THEN 6\n    WHEN 'INTEGER'                     THEN 4\n    WHEN 'INTERVAL'                    THEN 1111\n    WHEN 'JAVA_OBJECT'                 THEN 2000\n    WHEN 'LONGNVARCHAR'                THEN -16\n    WHEN 'LONGVARBINARY'               THEN -4\n    WHEN 'LONGVARCHAR'                 THEN -1\n    WHEN 'MAP'                         THEN 1111\n    WHEN 'NATIONAL CHARACTER'          THEN -15\n    WHEN 'NATIONAL CHARACTER LARGE OBJECT' \n                                       THEN 2011\n    WHEN 'NULL'                        THEN 0\n    WHEN 'NUMERIC'                     THEN 2\n    WHEN 'NATIONAL CHARACTER'          THEN -15\n    WHEN 'NATIONAL CHARACTER VARYING'  THEN -9\n    WHEN 'OTHER'                       THEN 1111\n    WHEN 'REAL'                        THEN 7\n    WHEN 'REF'                         THEN 2006\n    WHEN 'ROWID'                       THEN -8\n    WHEN 'SMALLINT'                    THEN 5\n    WHEN 'SQLXML'                      THEN 2009\n    WHEN 'STRUCT'                      THEN 2002\n    WHEN 'TIME'                        THEN 92\n    WHEN 'TIMESTAMP'                   THEN 93\n    WHEN 'TINYINT'                     THEN -6\n    ELSE                                    1111\n  END                                    as  DATA_TYPE, \n  DATA_TYPE                     as  TYPE_NAME, \n  CASE DATA_TYPE \n    WHEN 'BOOLEAN', 'BIT'\n                         THEN 1 \n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC', \n         'REAL', 'FLOAT', 'DOUBLE' \n                         THEN NUMERIC_PRECISION \n    WHEN 'CHARACTER', 'CHARACTER VARYING' \n                         THEN CHARACTER_MAXIMUM_LENGTH \n    WHEN 'DATE'          THEN 10 \n    WHEN 'TIME'          THEN \n      CASE \n        WHEN DATETIME_PRECISION > 0 \n                         THEN          8 + 1 + DATETIME_PRECISION\n        ELSE                           8\n      END \n    WHEN 'TIMESTAMP'     THEN \n      CASE \n        WHEN DATETIME_PRECISION > 0                            THEN 10 + 1 + 8 + 1 + DATETIME_PRECISION\n        ELSE                  10 + 1 + 8\n      END \n    WHEN 'INTERVAL'      THEN \n      INTERVAL_PRECISION \n      + \n      CASE INTERVAL_TYPE \n        WHEN 'YEAR', 'MONTH', 'DAY' THEN 2 \n        WHEN 'HOUR', 'MINUTE'       THEN 3 \n        WHEN 'YEAR TO MONTH'        THEN 5 \n        WHEN 'DAY TO HOUR'          THEN 6 \n        WHEN 'HOUR TO MINUTE'       THEN 6 \n        WHEN 'DAY TO MINUTE'        THEN 9 \n        ELSE \n          CASE INTERVAL_TYPE \n            WHEN 'DAY TO SECOND'    THEN 12 \n            WHEN 'HOUR TO SECOND'   THEN  9 \n            WHEN 'MINUTE TO SECOND' THEN  6 \n            WHEN 'SECOND'           THEN  3 \n            ELSE \n                                    0-INTERVAL_PRECISION - 1 \n          END \n          + \n          DATETIME_PRECISION\n          + \n          CASE \n            WHEN DATETIME_PRECISION > 0 THEN 1\n            ELSE                             0 \n          END\n      END \n    WHEN 'BINARY', 'BINARY VARYING' \n                         THEN CHARACTER_MAXIMUM_LENGTH \n    ELSE                      NULL \n  END                                    as  COLUMN_SIZE, \n  CHARACTER_MAXIMUM_LENGTH      as  BUFFER_LENGTH, \n  CASE  DATA_TYPE\n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC'        THEN NUMERIC_SCALE \n    WHEN 'REAL'                      THEN 7\n    WHEN 'FLOAT'                     THEN 7\n    WHEN 'DOUBLE'                    THEN 15\n    WHEN 'DATE', 'TIME', 'TIMESTAMP' THEN DATETIME_PRECISION \n    WHEN 'INTERVAL'                  THEN DATETIME_PRECISION \n  END                                    as  DECIMAL_DIGITS, \n  CASE DATA_TYPE \n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC', \n         'REAL', 'FLOAT', 'DOUBLE'   THEN NUMERIC_PRECISION_RADIX \n    WHEN 'INTERVAL'                  THEN 10\n    WHEN 'DATE', 'TIME', 'TIMESTAMP' THEN 10\n    ELSE                                  NULL\n  END                                    as  NUM_PREC_RADIX, \n  CASE IS_NULLABLE \n    WHEN 'YES'      THEN 1\n    WHEN 'NO'       THEN 0\n    WHEN ''         THEN 2\n    ELSE                 -1\n  END                                    as  NULLABLE, \n  CAST( NULL as VARCHAR )       as  REMARKS, \n  COLUMN_DEFAULT                as  COLUMN_DEF, \n  0                             as  SQL_DATA_TYPE, \n  0                             as  SQL_DATETIME_SUB, \n  CASE DATA_TYPE\n    WHEN 'CHARACTER', \n         'CHARACTER VARYING', \n         'NATIONAL CHARACTER', \n         'NATIONAL CHARACTER VARYING' \n                                 THEN CHARACTER_OCTET_LENGTH \n    ELSE                              NULL \n  END                                    as  CHAR_OCTET_LENGTH, \n  ORDINAL_POSITION              as  ORDINAL_POSITION, \n  IS_NULLABLE                   as  IS_NULLABLE, \n  CAST( NULL as VARCHAR )       as  SCOPE_CATALOG, \n  CAST( NULL as VARCHAR )       as  SCOPE_SCHEMA, \n  CAST( NULL as VARCHAR )       as  SCOPE_TABLE, \n  CAST( NULL as INTEGER )       as  SOURCE_DATA_TYPE, \n  ''                            as  IS_AUTOINCREMENT, \n  ''                            as  IS_GENERATEDCOLUMN \n  FROM INFORMATION_SCHEMA.COLUMNS \n  WHERE 1=1 ");
        if (catalog != null) {
            sb.append("\n  AND TABLE_CATALOG = '" + DremioStringUtils.escapeSql(catalog) + "'");
        }
        if (schemaPattern.s != null) {
            sb.append("\n  AND TABLE_SCHEMA like '" + DremioStringUtils.escapeSql(schemaPattern.s) + "' escape '" + this.searchStringEscape + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append("\n  AND TABLE_NAME like '" + DremioStringUtils.escapeSql(tableNamePattern.s) + "' escape '" + this.searchStringEscape + "'");
        }
        if (columnNamePattern.s != null) {
            sb.append("\n  AND COLUMN_NAME like '" + DremioStringUtils.escapeSql(columnNamePattern.s) + "' escape '" + this.searchStringEscape + "'");
        }
        sb.append("\n ORDER BY TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME");
        return this.s(sb.toString());
    }
}

