/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import cdjd.com.dremio.exec.rpc.ConnectionFailedException;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.google.common.base.Strings;
import cdjd.com.google.common.collect.ImmutableMap;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;

public class DremioExceptionMapper {
    private static final String INVALID_AUTHORIZATION_SPECIFICATION = "28000";
    private static final String DISCONNECT_ERROR = "01002";
    private static final String UNABLE_TO_ESTABLISH_CONNECTION = "08001";
    private static final String STATUS_PREFIX = " Status: ";
    private static final Map<String, String> errorStatusSQLStateMap = new ImmutableMap.Builder<String, String>().put("AUTH_FAILED", "28000").put("CONNECTION_INVALID", "01002").build();

    private DremioExceptionMapper() {
    }

    public static SQLException map(RpcException rpcException) {
        return DremioExceptionMapper.map(rpcException, rpcException.getMessage(), new String[0]);
    }

    public static SQLException map(RpcException rpcException, String message, String ... args) {
        if (message != null && args != null) {
            message = String.format(message, args);
        }
        return new SQLException(message, DremioExceptionMapper.getSqlCode(rpcException), rpcException);
    }

    private static String getSqlCode(RpcException rpcException) {
        String sqlCode = DremioExceptionMapper.getSqlCodeFromRpcExceptionType(rpcException);
        if (sqlCode == null) {
            sqlCode = DremioExceptionMapper.getSqlCodeFromRpcExceptionStatus(rpcException);
        }
        return sqlCode;
    }

    private static String getSqlCodeFromRpcExceptionType(RpcException rpcException) {
        if (rpcException instanceof ConnectionFailedException) {
            return UNABLE_TO_ESTABLISH_CONNECTION;
        }
        return null;
    }

    private static String getSqlCodeFromRpcExceptionStatus(RpcException rpcException) {
        if (rpcException.getStatus() != null) {
            return errorStatusSQLStateMap.get(rpcException.getStatus());
        }
        return DremioExceptionMapper.getSqlCodeFromMessage(rpcException.getMessage());
    }

    private static String getSqlCodeFromMessage(String message) {
        if (Strings.isNullOrEmpty(message)) {
            return null;
        }
        int statusIndex = message.indexOf(STATUS_PREFIX);
        if (statusIndex == -1) {
            return null;
        }
        int endIndex = (message = message.substring(statusIndex + STATUS_PREFIX.length())).indexOf(44);
        if (endIndex == -1) {
            return null;
        }
        return errorStatusSQLStateMap.get(message.substring(0, endIndex).toUpperCase(Locale.getDefault()));
    }
}

