/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.reflections.scanners;

import cdjd.com.google.common.base.Joiner;
import cdjd.javassist.CannotCompileException;
import cdjd.javassist.ClassPool;
import cdjd.javassist.CtBehavior;
import cdjd.javassist.CtClass;
import cdjd.javassist.CtConstructor;
import cdjd.javassist.LoaderClassPath;
import cdjd.javassist.NotFoundException;
import cdjd.javassist.bytecode.MethodInfo;
import cdjd.javassist.expr.ConstructorCall;
import cdjd.javassist.expr.ExprEditor;
import cdjd.javassist.expr.FieldAccess;
import cdjd.javassist.expr.MethodCall;
import cdjd.javassist.expr.NewExpr;
import cdjd.org.reflections.ReflectionsException;
import cdjd.org.reflections.scanners.AbstractScanner;
import cdjd.org.reflections.util.ClasspathHelper;

public class MemberUsageScanner
extends AbstractScanner {
    private ClassPool classPool;

    public void scan(Object cls) {
        try {
            CtClass ctClass = this.getClassPool().get(this.getMetadataAdapter().getClassName(cls));
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                this.scanMember(ctConstructor);
            }
            for (CtBehavior ctBehavior : ctClass.getDeclaredMethods()) {
                this.scanMember(ctBehavior);
            }
            ctClass.detach();
        }
        catch (Exception e) {
            throw new ReflectionsException("Could not scan method usage for " + this.getMetadataAdapter().getClassName(cls), e);
        }
    }

    void scanMember(CtBehavior member) throws CannotCompileException {
        final String key = member.getDeclaringClass().getName() + "." + member.getMethodInfo().getName() + "(" + this.parameterNames(member.getMethodInfo()) + ")";
        member.instrument(new ExprEditor(){

            public void edit(NewExpr e) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(e.getConstructor().getDeclaringClass().getName() + "." + "<init>" + "(" + MemberUsageScanner.this.parameterNames(e.getConstructor().getMethodInfo()) + ")", e.getLineNumber(), key);
                }
                catch (NotFoundException e1) {
                    throw new ReflectionsException("Could not find new instance usage in " + key, e1);
                }
            }

            public void edit(MethodCall m3) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(m3.getMethod().getDeclaringClass().getName() + "." + m3.getMethodName() + "(" + MemberUsageScanner.this.parameterNames(m3.getMethod().getMethodInfo()) + ")", m3.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + m3.getClassName() + " in " + key, e);
                }
            }

            public void edit(ConstructorCall c) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(c.getConstructor().getDeclaringClass().getName() + "." + "<init>" + "(" + MemberUsageScanner.this.parameterNames(c.getConstructor().getMethodInfo()) + ")", c.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + c.getClassName() + " in " + key, e);
                }
            }

            public void edit(FieldAccess f) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(f.getField().getDeclaringClass().getName() + "." + f.getFieldName(), f.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + f.getFieldName() + " in " + key, e);
                }
            }
        });
    }

    private void put(String key, int lineNumber, String value) {
        if (this.acceptResult(key)) {
            this.getStore().put(key, value + " #" + lineNumber);
        }
    }

    String parameterNames(MethodInfo info) {
        return Joiner.on(", ").join(this.getMetadataAdapter().getParameterNames(info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getClassPool() {
        if (this.classPool == null) {
            MemberUsageScanner memberUsageScanner = this;
            synchronized (memberUsageScanner) {
                this.classPool = new ClassPool();
                ClassLoader[] classLoaders = this.getConfiguration().getClassLoaders();
                if (classLoaders == null) {
                    classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0]);
                }
                for (ClassLoader classLoader : classLoaders) {
                    this.classPool.appendClassPath(new LoaderClassPath(classLoader));
                }
            }
        }
        return this.classPool;
    }
}

