/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.zookeeper.server.quorum;

public class QuorumStats {
    private final Provider provider;

    protected QuorumStats(Provider provider) {
        this.provider = provider;
    }

    public String getServerState() {
        return this.provider.getServerState();
    }

    public String[] getQuorumPeers() {
        return this.provider.getQuorumPeers();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        String state = this.getServerState();
        if (state.equals("leading")) {
            sb.append("Followers:");
            for (String f : this.getQuorumPeers()) {
                sb.append(" ").append(f);
            }
            sb.append("\n");
        } else if (state.equals("following") || state.equals("observing")) {
            sb.append("Leader: ");
            String[] ldr = this.getQuorumPeers();
            if (ldr.length > 0) {
                sb.append(ldr[0]);
            } else {
                sb.append("not connected");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static interface Provider {
        public static final String UNKNOWN_STATE = "unknown";
        public static final String LOOKING_STATE = "leaderelection";
        public static final String LEADING_STATE = "leading";
        public static final String FOLLOWING_STATE = "following";
        public static final String OBSERVING_STATE = "observing";

        public String[] getQuorumPeers();

        public String getServerState();
    }
}

