/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.x.discovery.strategies;

import cdjd.org.apache.curator.x.discovery.ProviderStrategy;
import cdjd.org.apache.curator.x.discovery.ServiceInstance;
import cdjd.org.apache.curator.x.discovery.details.InstanceProvider;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinStrategy<T>
implements ProviderStrategy<T> {
    private final AtomicInteger index = new AtomicInteger(0);

    @Override
    public ServiceInstance<T> getInstance(InstanceProvider<T> instanceProvider) throws Exception {
        List<ServiceInstance<T>> instances = instanceProvider.getInstances();
        if (instances.size() == 0) {
            return null;
        }
        int thisIndex = Math.abs(this.index.getAndIncrement());
        return instances.get(thisIndex % instances.size());
    }
}

