/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.x.discovery.details;

import cdjd.org.apache.curator.framework.CuratorFramework;
import cdjd.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import cdjd.org.apache.curator.framework.api.BackgroundPathable;
import cdjd.org.apache.curator.framework.api.ChildrenDeletable;
import cdjd.org.apache.curator.framework.recipes.cache.NodeCache;
import cdjd.org.apache.curator.framework.recipes.cache.NodeCacheListener;
import cdjd.org.apache.curator.framework.state.ConnectionState;
import cdjd.org.apache.curator.framework.state.ConnectionStateListener;
import cdjd.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import cdjd.org.apache.curator.shaded.com.google.common.base.Preconditions;
import cdjd.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Lists;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Maps;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Sets;
import cdjd.org.apache.curator.utils.CloseableUtils;
import cdjd.org.apache.curator.utils.ExceptionAccumulator;
import cdjd.org.apache.curator.utils.ThreadUtils;
import cdjd.org.apache.curator.utils.ZKPaths;
import cdjd.org.apache.curator.x.discovery.ServiceCache;
import cdjd.org.apache.curator.x.discovery.ServiceCacheBuilder;
import cdjd.org.apache.curator.x.discovery.ServiceDiscovery;
import cdjd.org.apache.curator.x.discovery.ServiceInstance;
import cdjd.org.apache.curator.x.discovery.ServiceProvider;
import cdjd.org.apache.curator.x.discovery.ServiceProviderBuilder;
import cdjd.org.apache.curator.x.discovery.details.InstanceSerializer;
import cdjd.org.apache.curator.x.discovery.details.ServiceCacheBuilderImpl;
import cdjd.org.apache.curator.x.discovery.details.ServiceProviderBuilderImpl;
import cdjd.org.apache.curator.x.discovery.strategies.RoundRobinStrategy;
import cdjd.org.apache.zookeeper.CreateMode;
import cdjd.org.apache.zookeeper.KeeperException;
import cdjd.org.apache.zookeeper.Watcher;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryImpl<T>
implements ServiceDiscovery<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String basePath;
    private final InstanceSerializer<T> serializer;
    private final ConcurrentMap<String, Entry<T>> services = Maps.newConcurrentMap();
    private final Collection<ServiceCache<T>> caches = Sets.newSetFromMap(Maps.newConcurrentMap());
    private final Collection<ServiceProvider<T>> providers = Sets.newSetFromMap(Maps.newConcurrentMap());
    private final boolean watchInstances;
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED || newState == ConnectionState.CONNECTED) {
                try {
                    ServiceDiscoveryImpl.this.log.debug("Re-registering due to reconnection");
                    ServiceDiscoveryImpl.this.reRegisterServices();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    ServiceDiscoveryImpl.this.log.error("Could not re-register instances after reconnection", e);
                }
            }
        }
    };

    public ServiceDiscoveryImpl(CuratorFramework client, String basePath, InstanceSerializer<T> serializer, ServiceInstance<T> thisInstance, boolean watchInstances) {
        this.watchInstances = watchInstances;
        this.client = Preconditions.checkNotNull(client, "client cannot be null");
        this.basePath = Preconditions.checkNotNull(basePath, "basePath cannot be null");
        this.serializer = Preconditions.checkNotNull(serializer, "serializer cannot be null");
        if (thisInstance != null) {
            Entry entry = new Entry(thisInstance);
            entry.cache = this.makeNodeCache(thisInstance);
            this.services.put(thisInstance.getId(), entry);
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.reRegisterServices();
        }
        catch (KeeperException e) {
            this.log.error("Could not register instances - will try again later", e);
        }
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
    }

    @Override
    public void close() throws IOException {
        ExceptionAccumulator accumulator = new ExceptionAccumulator();
        for (ServiceProvider<T> provider : Lists.newArrayList(this.providers)) {
            CloseableUtils.closeQuietly(provider);
        }
        for (Entry entry : this.services.values()) {
            try {
                this.internalUnregisterService(entry);
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
            catch (Exception e) {
                accumulator.add(e);
                this.log.error("Could not unregister instance: " + entry.service.getName(), e);
            }
        }
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        accumulator.propagate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(ServiceInstance<T> service) throws Exception {
        Entry useEntry;
        Entry newEntry = new Entry(service);
        Entry oldEntry = this.services.putIfAbsent(service.getId(), newEntry);
        Entry entry = useEntry = oldEntry != null ? oldEntry : newEntry;
        synchronized (entry) {
            if (useEntry == newEntry) {
                useEntry.cache = this.makeNodeCache(service);
            }
            this.internalRegisterService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateService(ServiceInstance<T> service) throws Exception {
        Entry entry = (Entry)this.services.get(service.getId());
        if (entry == null) {
            throw new Exception("Service not registered: " + service);
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            entry.service = service;
            byte[] bytes = this.serializer.serialize(service);
            String path = this.pathForInstance(service.getName(), service.getId());
            this.client.setData().forPath(path, bytes);
        }
    }

    @VisibleForTesting
    protected void internalRegisterService(ServiceInstance<T> service) throws Exception {
        byte[] bytes = this.serializer.serialize(service);
        String path = this.pathForInstance(service.getName(), service.getId());
        int MAX_TRIES = 2;
        boolean isDone = false;
        for (int i = 0; !isDone && i < 2; ++i) {
            try {
                CreateMode mode;
                switch (service.getServiceType()) {
                    case DYNAMIC: {
                        mode = CreateMode.EPHEMERAL;
                        break;
                    }
                    case DYNAMIC_SEQUENTIAL: {
                        mode = CreateMode.EPHEMERAL_SEQUENTIAL;
                        break;
                    }
                    default: {
                        mode = CreateMode.PERSISTENT;
                    }
                }
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(mode)).forPath(path, bytes);
                isDone = true;
                continue;
            }
            catch (KeeperException.NodeExistsException e) {
                this.client.delete().forPath(path);
            }
        }
    }

    @Override
    public void unregisterService(ServiceInstance<T> service) throws Exception {
        Entry entry = (Entry)this.services.remove(service.getId());
        this.internalUnregisterService(entry);
    }

    @Override
    public ServiceProviderBuilder<T> serviceProviderBuilder() {
        return new ServiceProviderBuilderImpl(this).providerStrategy(new RoundRobinStrategy()).threadFactory(ThreadUtils.newThreadFactory("ServiceProvider"));
    }

    @Override
    public ServiceCacheBuilder<T> serviceCacheBuilder() {
        return new ServiceCacheBuilderImpl(this).threadFactory(ThreadUtils.newThreadFactory("ServiceCache"));
    }

    @Override
    public Collection<String> queryForNames() throws Exception {
        List names = (List)this.client.getChildren().forPath(this.basePath);
        return ImmutableList.copyOf(names);
    }

    @Override
    public Collection<ServiceInstance<T>> queryForInstances(String name) throws Exception {
        return this.queryForInstances(name, null);
    }

    @Override
    public ServiceInstance<T> queryForInstance(String name, String id) throws Exception {
        String path = this.pathForInstance(name, id);
        try {
            byte[] bytes = (byte[])this.client.getData().forPath(path);
            return this.serializer.deserialize(bytes);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return null;
        }
    }

    void cacheOpened(ServiceCache<T> cache) {
        this.caches.add(cache);
    }

    void cacheClosed(ServiceCache<T> cache) {
        this.caches.remove(cache);
    }

    void providerOpened(ServiceProvider<T> provider) {
        this.providers.add(provider);
    }

    void providerClosed(ServiceProvider<T> cache) {
        this.providers.remove(cache);
    }

    CuratorFramework getClient() {
        return this.client;
    }

    String pathForName(String name) {
        return ZKPaths.makePath(this.basePath, name);
    }

    InstanceSerializer<T> getSerializer() {
        return this.serializer;
    }

    List<ServiceInstance<T>> queryForInstances(String name, Watcher watcher) throws Exception {
        List<Object> instanceIds;
        ImmutableList.Builder builder = ImmutableList.builder();
        String path = this.pathForName(name);
        if (watcher != null) {
            instanceIds = this.getChildrenWatched(path, watcher, true);
        } else {
            try {
                instanceIds = (List)this.client.getChildren().forPath(path);
            }
            catch (KeeperException.NoNodeException e) {
                instanceIds = Lists.newArrayList();
            }
        }
        for (String string : instanceIds) {
            ServiceInstance<T> instance = this.queryForInstance(name, string);
            if (instance == null) continue;
            builder.add(instance);
        }
        return builder.build();
    }

    @VisibleForTesting
    int debugServicesQty() {
        return this.services.size();
    }

    private List<String> getChildrenWatched(String path, Watcher watcher, boolean recurse) throws Exception {
        List<String> instanceIds;
        try {
            instanceIds = (List<String>)((BackgroundPathable)this.client.getChildren().usingWatcher(watcher)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            if (recurse) {
                try {
                    this.client.create().creatingParentContainersIfNeeded().forPath(path);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
                instanceIds = this.getChildrenWatched(path, watcher, false);
            }
            throw e;
        }
        return instanceIds;
    }

    @VisibleForTesting
    String pathForInstance(String name, String id) {
        return ZKPaths.makePath(this.pathForName(name), id);
    }

    @VisibleForTesting
    ServiceInstance<T> getRegisteredService(String id) {
        Entry entry = (Entry)this.services.get(id);
        return entry != null ? entry.service : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRegisterServices() throws Exception {
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            Entry entry;
            Entry entry2 = entry = (Entry)iterator.next();
            synchronized (entry2) {
                this.internalRegisterService(entry.service);
            }
        }
    }

    private NodeCache makeNodeCache(final ServiceInstance<T> instance) {
        if (!this.watchInstances) {
            return null;
        }
        final NodeCache nodeCache = new NodeCache(this.client, this.pathForInstance(instance.getName(), instance.getId()));
        try {
            nodeCache.start(true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            this.log.error("Could not start node cache for: " + instance, e);
        }
        NodeCacheListener listener = new NodeCacheListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nodeChanged() throws Exception {
                if (nodeCache.getCurrentData() != null) {
                    ServiceInstance newInstance = ServiceDiscoveryImpl.this.serializer.deserialize(nodeCache.getCurrentData().getData());
                    Entry entry = (Entry)ServiceDiscoveryImpl.this.services.get(newInstance.getId());
                    if (entry != null) {
                        Entry entry2 = entry;
                        synchronized (entry2) {
                            entry.service = newInstance;
                        }
                    }
                } else {
                    ServiceDiscoveryImpl.this.log.warn("Instance data has been deleted for: " + instance);
                }
            }
        };
        nodeCache.getListenable().addListener(listener);
        return nodeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterService(Entry<T> entry) throws Exception {
        if (entry != null) {
            Entry<T> entry2 = entry;
            synchronized (entry2) {
                if (((Entry)entry).cache != null) {
                    CloseableUtils.closeQuietly(((Entry)entry).cache);
                    ((Entry)entry).cache = null;
                }
                String path = this.pathForInstance(((Entry)entry).service.getName(), ((Entry)entry).service.getId());
                try {
                    ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(path);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
        }
    }

    private static class Entry<T> {
        private volatile ServiceInstance<T> service;
        private volatile NodeCache cache;

        private Entry(ServiceInstance<T> service) {
            this.service = service;
        }
    }
}

