/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.x.discovery;

import cdjd.org.apache.curator.shaded.com.google.common.base.Preconditions;
import cdjd.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Iterators;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Lists;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Maps;
import cdjd.org.apache.curator.x.discovery.ServiceInstance;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriSpec
implements Iterable<Part> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<Part> parts = Lists.newArrayList();
    public static final String FIELD_SCHEME = "scheme";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";
    public static final String FIELD_ADDRESS = "address";
    public static final String FIELD_PORT = "port";
    public static final String FIELD_SSL_PORT = "ssl-port";
    public static final String FIELD_REGISTRATION_TIME_UTC = "registration-time-utc";
    public static final String FIELD_SERVICE_TYPE = "service-type";
    public static final String FIELD_OPEN_BRACE = "[";
    public static final String FIELD_CLOSE_BRACE = "]";

    public UriSpec() {
    }

    public UriSpec(String rawSpec) {
        boolean isInsideVariable = false;
        StringTokenizer tokenizer = new StringTokenizer(rawSpec, "{}", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("{")) {
                Preconditions.checkState(!isInsideVariable, "{ is not allowed inside of a variable specification");
                isInsideVariable = true;
                continue;
            }
            if (token.equals("}")) {
                Preconditions.checkState(isInsideVariable, "} must be preceded by {");
                isInsideVariable = false;
                continue;
            }
            if (isInsideVariable) {
                token = token.trim();
            }
            this.add(new Part(token, isInsideVariable));
        }
        Preconditions.checkState(!isInsideVariable, "Final variable not closed - expected }");
    }

    public String build() {
        return this.build(null, Maps.newHashMap());
    }

    public String build(ServiceInstance<?> serviceInstance) {
        return this.build(serviceInstance, Maps.newHashMap());
    }

    public String build(Map<String, Object> variables) {
        return this.build(null, variables);
    }

    public String build(ServiceInstance<?> serviceInstance, Map<String, Object> variables) {
        HashMap<String, Object> localVariables = Maps.newHashMap();
        localVariables.put(FIELD_OPEN_BRACE, "{");
        localVariables.put(FIELD_CLOSE_BRACE, "}");
        localVariables.put(FIELD_SCHEME, "http");
        if (serviceInstance != null) {
            localVariables.put(FIELD_NAME, this.nullCheck(serviceInstance.getName()));
            localVariables.put(FIELD_ID, this.nullCheck(serviceInstance.getId()));
            localVariables.put(FIELD_ADDRESS, this.nullCheck(serviceInstance.getAddress()));
            localVariables.put(FIELD_PORT, this.nullCheck(serviceInstance.getPort()));
            localVariables.put(FIELD_SSL_PORT, this.nullCheck(serviceInstance.getSslPort()));
            localVariables.put(FIELD_REGISTRATION_TIME_UTC, this.nullCheck(serviceInstance.getRegistrationTimeUTC()));
            localVariables.put(FIELD_SERVICE_TYPE, serviceInstance.getServiceType() != null ? serviceInstance.getServiceType().name().toLowerCase() : "");
            if (serviceInstance.getSslPort() != null) {
                localVariables.put(FIELD_SCHEME, "https");
            }
        }
        localVariables.putAll(variables);
        StringBuilder str = new StringBuilder();
        for (Part p : this.parts) {
            if (p.isVariable()) {
                Object value = localVariables.get(p.getValue());
                if (value == null) {
                    this.log.debug("Variable not found: " + p.getValue());
                    continue;
                }
                str.append(value);
                continue;
            }
            str.append(p.getValue());
        }
        return str.toString();
    }

    @Override
    public Iterator<Part> iterator() {
        return Iterators.unmodifiableIterator(this.parts.iterator());
    }

    public List<Part> getParts() {
        return ImmutableList.copyOf(this.parts);
    }

    public void add(Part part) {
        this.parts.add(part);
    }

    public void remove(Part part) {
        this.parts.remove(part);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriSpec spec = (UriSpec)o;
        return this.parts.equals(spec.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    private Object nullCheck(Object o) {
        return o != null ? o : "";
    }

    public static class Part {
        private final String value;
        private final boolean variable;

        public Part(String value, boolean isVariable) {
            this.value = value;
            this.variable = isVariable;
        }

        public Part() {
            this.value = "";
            this.variable = false;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isVariable() {
            return this.variable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Part part = (Part)o;
            if (this.variable != part.variable) {
                return false;
            }
            return this.value.equals(part.value);
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.variable ? 1 : 0);
            return result;
        }
    }
}

