/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.framework.imps;

import cdjd.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import cdjd.org.apache.curator.framework.imps.NamespaceWatcher;
import cdjd.org.apache.curator.framework.imps.RemoveWatchesBuilderImpl;
import cdjd.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import cdjd.org.apache.curator.shaded.com.google.common.base.Preconditions;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Lists;
import cdjd.org.apache.curator.shaded.com.google.common.collect.Sets;
import cdjd.org.apache.zookeeper.Watcher;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherRemovalManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private final Set<NamespaceWatcher> entries = Sets.newConcurrentHashSet();

    WatcherRemovalManager(CuratorFrameworkImpl client) {
        this.client = client;
    }

    void add(NamespaceWatcher watcher) {
        watcher = Preconditions.checkNotNull(watcher, "watcher cannot be null");
        this.entries.add(watcher);
    }

    @VisibleForTesting
    Set<? extends Watcher> getEntries() {
        return Sets.newHashSet(this.entries);
    }

    void removeWatchers() {
        if (this.client.isZk34CompatibilityMode()) {
            return;
        }
        ArrayList<NamespaceWatcher> localEntries = Lists.newArrayList(this.entries);
        while (localEntries.size() > 0) {
            NamespaceWatcher watcher = (NamespaceWatcher)localEntries.remove(0);
            if (!this.entries.remove(watcher) || this.client.isZk34CompatibilityMode()) continue;
            try {
                this.log.debug("Removing watcher for path: " + watcher.getUnfixedPath());
                RemoveWatchesBuilderImpl builder = new RemoveWatchesBuilderImpl(this.client);
                builder.internalRemoval(watcher, watcher.getUnfixedPath());
            }
            catch (Exception e) {
                this.log.error("Could not remove watcher for path: " + watcher.getUnfixedPath());
            }
        }
    }

    void noteTriggeredWatcher(NamespaceWatcher watcher) {
        this.entries.remove(watcher);
    }
}

