/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.framework.imps;

import cdjd.org.apache.curator.RetryLoop;
import cdjd.org.apache.curator.TimeTrace;
import cdjd.org.apache.curator.framework.api.BackgroundCallback;
import cdjd.org.apache.curator.framework.api.ConfigureEnsembleable;
import cdjd.org.apache.curator.framework.api.CuratorEventType;
import cdjd.org.apache.curator.framework.api.Ensembleable;
import cdjd.org.apache.curator.framework.api.ErrorListenerReconfigBuilderMain;
import cdjd.org.apache.curator.framework.api.JoinStatConfigEnsembleable;
import cdjd.org.apache.curator.framework.api.LeaveStatConfigEnsembleable;
import cdjd.org.apache.curator.framework.api.ReconfigBuilder;
import cdjd.org.apache.curator.framework.api.ReconfigBuilderMain;
import cdjd.org.apache.curator.framework.api.StatConfigureEnsembleable;
import cdjd.org.apache.curator.framework.api.UnhandledErrorListener;
import cdjd.org.apache.curator.framework.imps.BackgroundOperation;
import cdjd.org.apache.curator.framework.imps.Backgrounding;
import cdjd.org.apache.curator.framework.imps.CuratorEventImpl;
import cdjd.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import cdjd.org.apache.curator.framework.imps.OperationAndData;
import cdjd.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import cdjd.org.apache.zookeeper.AsyncCallback;
import cdjd.org.apache.zookeeper.data.Stat;
import cdjd.org.apache.zookeeper.server.DataTree;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class ReconfigBuilderImpl
implements ReconfigBuilder,
BackgroundOperation<Void>,
ErrorListenerReconfigBuilderMain {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding = new Backgrounding();
    private Stat responseStat;
    private long fromConfig = -1L;
    private List<String> newMembers;
    private List<String> joining;
    private List<String> leaving;

    public ReconfigBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
    }

    public ReconfigBuilderImpl(CuratorFrameworkImpl client, Backgrounding backgrounding, Stat responseStat, long fromConfig, List<String> newMembers, List<String> joining, List<String> leaving) {
        this.client = client;
        this.backgrounding = backgrounding;
        this.responseStat = responseStat;
        this.fromConfig = fromConfig;
        this.newMembers = newMembers;
        this.joining = joining;
        this.leaving = leaving;
    }

    public byte[] forEnsemble() throws Exception {
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<Object>(this, null, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), null), null);
            return new byte[0];
        }
        return this.ensembleInForeground();
    }

    @Override
    public ErrorListenerReconfigBuilderMain inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerReconfigBuilderMain inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerReconfigBuilderMain inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerReconfigBuilderMain inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerReconfigBuilderMain inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(callback, executor);
        return this;
    }

    @Override
    public ErrorListenerReconfigBuilderMain inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ReconfigBuilderMain withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public StatConfigureEnsembleable withNewMembers(String ... server) {
        return this.withNewMembers((List)(server != null ? Arrays.asList(server) : null));
    }

    @Override
    public StatConfigureEnsembleable withNewMembers(List<String> servers) {
        this.newMembers = servers != null ? ImmutableList.copyOf(servers) : ImmutableList.of();
        return new StatConfigureEnsembleable(){

            @Override
            public Ensembleable<byte[]> fromConfig(long config) throws Exception {
                ReconfigBuilderImpl.this.fromConfig = config;
                return this;
            }

            @Override
            public byte[] forEnsemble() throws Exception {
                return ReconfigBuilderImpl.this.forEnsemble();
            }

            @Override
            public ConfigureEnsembleable storingStatIn(Stat stat) {
                ReconfigBuilderImpl.this.responseStat = stat;
                return this;
            }
        };
    }

    @Override
    public LeaveStatConfigEnsembleable joining(String ... server) {
        return this.joining((List)(server != null ? Arrays.asList(server) : null));
    }

    @Override
    public LeaveStatConfigEnsembleable joining(List<String> servers) {
        this.joining = servers != null ? ImmutableList.copyOf(servers) : ImmutableList.of();
        return new LeaveStatConfigEnsembleable(){

            @Override
            public byte[] forEnsemble() throws Exception {
                return ReconfigBuilderImpl.this.forEnsemble();
            }

            @Override
            public ConfigureEnsembleable storingStatIn(Stat stat) {
                ReconfigBuilderImpl.this.responseStat = stat;
                return this;
            }

            @Override
            public Ensembleable<byte[]> fromConfig(long config) throws Exception {
                ReconfigBuilderImpl.this.fromConfig = config;
                return this;
            }

            @Override
            public JoinStatConfigEnsembleable leaving(String ... server) {
                return ReconfigBuilderImpl.this.leaving(server);
            }

            @Override
            public JoinStatConfigEnsembleable leaving(List<String> servers) {
                return ReconfigBuilderImpl.this.leaving((List)servers);
            }
        };
    }

    @Override
    public JoinStatConfigEnsembleable leaving(String ... server) {
        return this.leaving((List)(server != null ? Arrays.asList(server) : null));
    }

    @Override
    public JoinStatConfigEnsembleable leaving(List<String> servers) {
        this.leaving = servers != null ? ImmutableList.copyOf(servers) : ImmutableList.of();
        return new JoinStatConfigEnsembleable(){

            @Override
            public byte[] forEnsemble() throws Exception {
                return ReconfigBuilderImpl.this.forEnsemble();
            }

            @Override
            public ConfigureEnsembleable storingStatIn(Stat stat) {
                ReconfigBuilderImpl.this.responseStat = stat;
                return this;
            }

            @Override
            public Ensembleable<byte[]> fromConfig(long config) throws Exception {
                ReconfigBuilderImpl.this.fromConfig = config;
                return this;
            }

            @Override
            public LeaveStatConfigEnsembleable joining(String ... server) {
                return this.joining((List)(server != null ? Arrays.asList(server) : null));
            }

            @Override
            public LeaveStatConfigEnsembleable joining(List<String> servers) {
                return ReconfigBuilderImpl.this.joining((List)servers);
            }
        };
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<Void> data) throws Exception {
        try {
            final TimeTrace trace = this.client.getZookeeperClient().startTracer("ReconfigBuilderImpl-Background");
            AsyncCallback.DataCallback callback = new AsyncCallback.DataCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, byte[] bytes, Stat stat) {
                    trace.commit();
                    if (ReconfigBuilderImpl.this.responseStat != null && stat != null) {
                        DataTree.copyStat(stat, ReconfigBuilderImpl.this.responseStat);
                    }
                    CuratorEventImpl event = new CuratorEventImpl(ReconfigBuilderImpl.this.client, CuratorEventType.RECONFIG, rc, path, null, ctx, stat, bytes, null, null, null, null);
                    ReconfigBuilderImpl.this.client.processBackgroundOperation(data, event);
                }
            };
            this.client.getZooKeeper().reconfig(this.joining, this.leaving, this.newMembers, this.fromConfig, callback, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    private byte[] ensembleInForeground() throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("ReconfigBuilderImpl-Foreground");
        byte[] responseData = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return ReconfigBuilderImpl.this.client.getZooKeeper().reconfig(ReconfigBuilderImpl.this.joining, ReconfigBuilderImpl.this.leaving, ReconfigBuilderImpl.this.newMembers, ReconfigBuilderImpl.this.fromConfig, ReconfigBuilderImpl.this.responseStat);
            }
        });
        trace.commit();
        return responseData;
    }
}

