/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex.impl;

import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.complex.ListVector;
import cdjd.org.apache.arrow.vector.complex.NonNullableStructVector;
import cdjd.org.apache.arrow.vector.complex.StateTool;
import cdjd.org.apache.arrow.vector.complex.StructVector;
import cdjd.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import cdjd.org.apache.arrow.vector.complex.impl.NullableStructWriter;
import cdjd.org.apache.arrow.vector.complex.impl.NullableStructWriterFactory;
import cdjd.org.apache.arrow.vector.complex.impl.UnionListWriter;
import cdjd.org.apache.arrow.vector.complex.writer.BaseWriter;
import cdjd.org.apache.arrow.vector.types.pojo.Field;

public class ComplexWriterImpl
extends AbstractFieldWriter
implements BaseWriter.ComplexWriter {
    private NullableStructWriter structRoot;
    private UnionListWriter listRoot;
    private final NonNullableStructVector container;
    Mode mode = Mode.INIT;
    private final String name;
    private final boolean unionEnabled;
    private final NullableStructWriterFactory nullableStructWriterFactory;

    public ComplexWriterImpl(String name, NonNullableStructVector container, boolean unionEnabled, boolean caseSensitive) {
        this.name = name;
        this.container = container;
        this.unionEnabled = unionEnabled;
        this.nullableStructWriterFactory = caseSensitive ? NullableStructWriterFactory.getNullableCaseSensitiveStructWriterFactoryInstance() : NullableStructWriterFactory.getNullableStructWriterFactoryInstance();
    }

    public ComplexWriterImpl(String name, NonNullableStructVector container, boolean unionEnabled) {
        this(name, container, unionEnabled, false);
    }

    public ComplexWriterImpl(String name, NonNullableStructVector container) {
        this(name, container, false);
    }

    @Override
    public Field getField() {
        return this.container.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.container.getValueCapacity();
    }

    private void check(Mode ... modes) {
        StateTool.check((Enum)this.mode, (Enum[])modes);
    }

    @Override
    public void reset() {
        this.setPosition(0);
    }

    @Override
    public void close() throws Exception {
        this.clear();
        this.structRoot.close();
        if (this.listRoot != null) {
            this.listRoot.close();
        }
    }

    @Override
    public void clear() {
        switch (this.mode) {
            case STRUCT: {
                this.structRoot.clear();
                break;
            }
            case LIST: {
                this.listRoot.clear();
                break;
            }
        }
    }

    @Override
    public void setValueCount(int count) {
        switch (this.mode) {
            case STRUCT: {
                this.structRoot.setValueCount(count);
                break;
            }
            case LIST: {
                this.listRoot.setValueCount(count);
                break;
            }
        }
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        switch (this.mode) {
            case STRUCT: {
                this.structRoot.setPosition(index);
                break;
            }
            case LIST: {
                this.listRoot.setPosition(index);
                break;
            }
        }
    }

    public BaseWriter.StructWriter directStruct() {
        Preconditions.checkArgument(this.name == null);
        switch (this.mode) {
            case INIT: {
                this.structRoot = this.nullableStructWriterFactory.build((StructVector)this.container);
                this.structRoot.setPosition(this.idx());
                this.mode = Mode.STRUCT;
                break;
            }
            case STRUCT: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.STRUCT);
            }
        }
        return this.structRoot;
    }

    @Override
    public BaseWriter.StructWriter rootAsStruct() {
        switch (this.mode) {
            case INIT: {
                StructVector struct = this.container.addOrGetStruct(this.name);
                this.structRoot = this.nullableStructWriterFactory.build(struct);
                this.structRoot.setPosition(this.idx());
                this.mode = Mode.STRUCT;
                break;
            }
            case STRUCT: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.STRUCT);
            }
        }
        return this.structRoot;
    }

    @Override
    public void allocate() {
        if (this.structRoot != null) {
            this.structRoot.allocate();
        } else if (this.listRoot != null) {
            this.listRoot.allocate();
        }
    }

    @Override
    public BaseWriter.ListWriter rootAsList() {
        switch (this.mode) {
            case INIT: {
                int vectorCount = this.container.size();
                ListVector listVector = this.container.addOrGetList(this.name);
                if (this.container.size() > vectorCount) {
                    listVector.allocateNew();
                }
                this.listRoot = new UnionListWriter(listVector, this.nullableStructWriterFactory);
                this.listRoot.setPosition(this.idx());
                this.mode = Mode.LIST;
                break;
            }
            case LIST: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.STRUCT);
            }
        }
        return this.listRoot;
    }

    private static enum Mode {
        INIT,
        STRUCT,
        LIST;

    }
}

