/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex;

import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.AddOrGetResult;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.complex.ListVector;
import cdjd.org.apache.arrow.vector.complex.impl.UnionMapReader;
import cdjd.org.apache.arrow.vector.complex.impl.UnionMapWriter;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.CallBack;
import java.util.List;

public class MapVector
extends ListVector {
    public static final String KEY_NAME = "key";
    public static final String VALUE_NAME = "value";
    public static final String DATA_VECTOR_NAME = "entries";

    public static MapVector empty(String name, BufferAllocator allocator, boolean keysSorted) {
        return new MapVector(name, allocator, FieldType.nullable(new ArrowType.Map(keysSorted)), null);
    }

    public MapVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        super(name, allocator, fieldType, callBack);
        this.defaultDataVectorName = DATA_VECTOR_NAME;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        Preconditions.checkArgument(children.size() == 1, "Maps have one List child. Found: %s", children);
        Field structField = children.get(0);
        Types.MinorType minorType = Types.getMinorTypeForArrowType(structField.getType());
        Preconditions.checkArgument(minorType == Types.MinorType.STRUCT && !structField.isNullable(), "Map data should be a non-nullable struct type");
        Preconditions.checkArgument(structField.getChildren().size() == 2, "Map data should be a struct with 2 children. Found: %s", children);
        Field keyField = structField.getChildren().get(0);
        Preconditions.checkArgument(!keyField.isNullable(), "Map data key type should be a non-nullable");
        AddOrGetResult addOrGetVector = this.addOrGetVector(structField.getFieldType());
        Preconditions.checkArgument(addOrGetVector.isCreated(), "Child vector already existed: %s", addOrGetVector.getVector());
        ((FieldVector)addOrGetVector.getVector()).initializeChildrenFromFields(structField.getChildren());
    }

    @Override
    public UnionMapWriter getWriter() {
        return new UnionMapWriter(this);
    }

    @Override
    public UnionMapReader getReader() {
        if (this.reader == null) {
            this.reader = new UnionMapReader(this);
        }
        return (UnionMapReader)this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.MAP;
    }
}

