/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.common.util.MajorTypeHelper;
import cdjd.com.dremio.exec.expr.TypeHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.util.CommonUtil;
import cdjd.org.apache.arrow.memory.util.LargeMemoryUtil;
import cdjd.org.apache.arrow.vector.BaseValueVectorHelper;
import cdjd.org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;

public abstract class BaseRepeatedValueVectorHelper<T extends BaseRepeatedValueVector>
extends BaseValueVectorHelper<T> {
    private BaseRepeatedValueVector vector;

    public BaseRepeatedValueVectorHelper(T vector) {
        super(vector);
        this.vector = vector;
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        UserBitShared.SerializedField offsetField = this.buildOffsetMetadata();
        return super.getMetadataBuilder().addChild(offsetField).addChild(TypeHelper.getMetadata(this.vector.vector));
    }

    protected UserBitShared.SerializedField buildOffsetMetadata() {
        UserBitShared.SerializedField.Builder offsetBuilder = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("$offsets$").build()).setValueCount(this.vector.valueCount == 0 ? 0 : this.vector.valueCount + 1).setBufferLength(this.vector.valueCount == 0 ? 0 : (this.vector.valueCount + 1) * 4).setMajorType(Types.required(TypeProtos.MinorType.UINT4));
        return offsetBuilder.build();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        this.vector.clear();
        UserBitShared.SerializedField offsetMetadata = metadata.getChild(0);
        UserBitShared.SerializedField vectorMetadata = metadata.getChild(1);
        int offsetLength = offsetMetadata.getBufferLength();
        int vectorLength = vectorMetadata.getBufferLength();
        this.loadOffsetBuffer(offsetMetadata, buffer);
        if (this.vector.getDataVector() == BaseRepeatedValueVector.DEFAULT_DATA_VECTOR) {
            this.vector.addOrGetVector(FieldType.nullable(MajorTypeHelper.getArrowMinorType(metadata.getMajorType().getMinorType()).getType()));
        }
        TypeHelper.load(this.vector.vector, vectorMetadata, buffer.slice(offsetLength, vectorLength));
    }

    protected void loadOffsetBuffer(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        int valueCount = metadata.getValueCount();
        int actualLength = metadata.getBufferLength();
        int expectedLength = valueCount * 4;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes in offset buffer but actually loaded %d bytes", expectedLength, actualLength);
        this.vector.offsetBuffer = buffer.slice(0L, actualLength);
        this.vector.offsetBuffer.writerIndex(actualLength);
        this.vector.offsetBuffer.retain(1);
    }

    public static void setOffsetHelper(BaseRepeatedValueVector vector, int indexToGet, int indexToSet, BufferAllocator vectorAllocator) {
        int valueToSet = vector.offsetBuffer.getInt(indexToGet * 4);
        while (indexToSet >= BaseRepeatedValueVectorHelper.getOffsetBufferValueCapacity(vector)) {
            BaseRepeatedValueVectorHelper.reallocOffsetBuffer(vector, vectorAllocator);
        }
        vector.offsetBuffer.setInt(indexToSet * 4, valueToSet);
    }

    private static int getOffsetBufferValueCapacity(BaseRepeatedValueVector vector) {
        return (int)((double)vector.offsetBuffer.capacity() * 1.0 / 4.0);
    }

    private static void reallocOffsetBuffer(BaseRepeatedValueVector vector, BufferAllocator allocator) {
        long baseSize = vector.offsetAllocationSizeInBytes;
        long currentBufferCapacity = vector.offsetBuffer.capacity();
        if (baseSize < currentBufferCapacity) {
            baseSize = currentBufferCapacity;
        }
        long newAllocationSize = baseSize * 2L;
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        int size = LargeMemoryUtil.checkedCastToInt(newAllocationSize);
        ArrowBuf newBuf = allocator.buffer(size);
        newBuf.setZero(0L, newBuf.capacity());
        newBuf.setBytes(0L, vector.offsetBuffer, 0L, currentBufferCapacity);
        vector.offsetBuffer.release(1);
        vector.offsetBuffer = newBuf;
        vector.offsetAllocationSizeInBytes = size;
    }
}

