/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.BaseFixedWidthVector;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.NullCheckingForGet;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.impl.TimeNanoReaderImpl;
import cdjd.org.apache.arrow.vector.complex.reader.FieldReader;
import cdjd.org.apache.arrow.vector.holders.NullableTimeNanoHolder;
import cdjd.org.apache.arrow.vector.holders.TimeNanoHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.TransferPair;

public final class TimeNanoVector
extends BaseFixedWidthVector {
    private static final byte TYPE_WIDTH = 8;
    private final FieldReader reader = new TimeNanoReaderImpl(this);

    public TimeNanoVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMENANO.getType()), allocator);
    }

    public TimeNanoVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public TimeNanoVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 8);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMENANO;
    }

    public long get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getLong((long)index * 8L);
    }

    public void get(int index, NullableTimeNanoHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
    }

    @Override
    public Long getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getLong((long)index * 8L);
    }

    private void setValue(int index, long value) {
        this.valueBuffer.setLong((long)index * 8L, value);
    }

    public void set(int index, long value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableTimeNanoHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeNanoHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, long value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableTimeNanoHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeNanoHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, long value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, long value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static long get(ArrowBuf buffer, int index) {
        return buffer.getLong((long)index * 8L);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((TimeNanoVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        TimeNanoVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new TimeNanoVector(ref, TimeNanoVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(TimeNanoVector to) {
            this.to = to;
        }

        @Override
        public TimeNanoVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TimeNanoVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TimeNanoVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TimeNanoVector.this);
        }
    }
}

